/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.participant.statemachine;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.helix.messaging.handling.BatchMessageWrapper;
import org.apache.helix.participant.statemachine.StateModel;

public abstract class StateModelFactory<T extends StateModel> {
    private final ConcurrentMap<String, ConcurrentMap<String, T>> _stateModelMap = new ConcurrentHashMap<String, ConcurrentMap<String, T>>();
    private final ConcurrentMap<String, BatchMessageWrapper> _batchMsgWrapperMap = new ConcurrentHashMap<String, BatchMessageWrapper>();

    public T createNewStateModel(String resourceName, String partitionName) {
        return this.createNewStateModel(partitionName);
    }

    @Deprecated
    public T createNewStateModel(String partitionName) {
        throw new UnsupportedOperationException("Please implement StateModelFactory#createNewStateModel(String resourceName, String partitionName)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T createAndAddStateModel(String resourceName, String partitionKey) {
        T stateModel = this.createNewStateModel(resourceName, partitionKey);
        ConcurrentMap<String, ConcurrentMap<String, T>> concurrentMap = this._stateModelMap;
        synchronized (concurrentMap) {
            if (!this._stateModelMap.containsKey(resourceName)) {
                this._stateModelMap.put(resourceName, new ConcurrentHashMap());
            }
            ((ConcurrentMap)this._stateModelMap.get(resourceName)).put(partitionKey, stateModel);
        }
        return stateModel;
    }

    @Deprecated
    public T createAndAddStateModel(String partitionName) {
        throw new UnsupportedOperationException("This method is replaced by StateModelFactory#createAndAddStateModel(String resourceName, String partitionKey)");
    }

    public T getStateModel(String resourceName, String partitionKey) {
        Map map = (Map)this._stateModelMap.get(resourceName);
        return (T)(map == null ? null : (StateModel)map.get(partitionKey));
    }

    @Deprecated
    public T getStateModel(String partitionName) {
        for (ConcurrentMap map : this._stateModelMap.values()) {
            if (!map.containsKey(partitionName)) continue;
            return (T)((StateModel)map.get(partitionName));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T removeStateModel(String resourceName, String partitionKey) {
        StateModel stateModel = null;
        ConcurrentMap<String, ConcurrentMap<String, T>> concurrentMap = this._stateModelMap;
        synchronized (concurrentMap) {
            Map map = (Map)this._stateModelMap.get(resourceName);
            if (map != null) {
                stateModel = (StateModel)map.remove(partitionKey);
                if (map.isEmpty()) {
                    this._stateModelMap.remove(resourceName);
                }
            }
        }
        return (T)stateModel;
    }

    @Deprecated
    public T removeStateModel(String partitionName) {
        for (ConcurrentMap map : this._stateModelMap.values()) {
            if (!map.containsKey(partitionName)) continue;
            return (T)((StateModel)map.remove(partitionName));
        }
        return null;
    }

    public Set<String> getResourceSet() {
        return this._stateModelMap.keySet();
    }

    public Set<String> getPartitionSet(String resourceName) {
        Map map = (Map)this._stateModelMap.get(resourceName);
        return map == null ? Collections.emptySet() : map.keySet();
    }

    @Deprecated
    public Set<String> getPartitionSet() {
        HashSet<String> allPartitions = new HashSet<String>();
        for (ConcurrentMap map : this._stateModelMap.values()) {
            allPartitions.addAll(map.keySet());
        }
        return allPartitions;
    }

    public BatchMessageWrapper createBatchMessageWrapper(String resourceName) {
        return new BatchMessageWrapper();
    }

    public BatchMessageWrapper createAndAddBatchMessageWrapper(String resourceName) {
        BatchMessageWrapper wrapper = this.createBatchMessageWrapper(resourceName);
        this._batchMsgWrapperMap.put(resourceName, wrapper);
        return wrapper;
    }

    public BatchMessageWrapper getBatchMessageWrapper(String resourceName) {
        return (BatchMessageWrapper)this._batchMsgWrapperMap.get(resourceName);
    }
}

