/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkDataListener;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.PropertyKey;
import org.apache.helix.ZNRecord;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.log4j.Logger;

public abstract class ClusterVerifier
implements IZkChildListener,
IZkDataListener {
    private static Logger LOG = Logger.getLogger(ClusterVerifier.class);
    protected final ZkClient _zkclient;
    protected final String _clusterName;
    protected final HelixDataAccessor _accessor;
    protected final PropertyKey.Builder _keyBuilder;
    private CountDownLatch _countdown;

    public ClusterVerifier(ZkClient zkclient, String clusterName) {
        this._zkclient = zkclient;
        this._clusterName = clusterName;
        this._accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(zkclient));
        this._keyBuilder = this._accessor.keyBuilder();
    }

    public boolean verifyByCallback(long timeout, List<ClusterVerifyTrigger> triggers) {
        this._countdown = new CountDownLatch(1);
        for (ClusterVerifyTrigger trigger : triggers) {
            String path = trigger._triggerKey.getPath();
            this._zkclient.subscribeChildChanges(path, this);
            if (!trigger._triggerOnChildDataChange) continue;
            List childs = this._zkclient.getChildren(path);
            for (String child : childs) {
                String childPath = String.format("%s/%s", path, child);
                this._zkclient.subscribeDataChanges(childPath, this);
            }
        }
        boolean success = false;
        try {
            success = this.verify();
            if (!success && !(success = this._countdown.await(timeout, TimeUnit.MILLISECONDS))) {
                success = this.verify();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception in verifier", (Throwable)e);
        }
        this._zkclient.unsubscribeAll();
        return success;
    }

    public void handleDataChange(String dataPath, Object data) throws Exception {
        boolean success = this.verify();
        if (success) {
            this._countdown.countDown();
        }
    }

    public void handleDataDeleted(String dataPath) throws Exception {
        this._zkclient.unsubscribeDataChanges(dataPath, this);
    }

    public void handleChildChange(String parentPath, List<String> currentChilds) throws Exception {
        for (String child : currentChilds) {
            String childPath = String.format("%s/%s", parentPath, child);
            this._zkclient.subscribeDataChanges(childPath, this);
        }
        boolean success = this.verify();
        if (success) {
            this._countdown.countDown();
        }
    }

    public boolean verifyByPolling(long timeout) {
        try {
            long start = System.currentTimeMillis();
            do {
                boolean success;
                if (success = this.verify()) {
                    return true;
                }
                TimeUnit.MILLISECONDS.sleep(500L);
            } while (System.currentTimeMillis() - start <= timeout);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception in verifier", (Throwable)e);
        }
        return false;
    }

    public abstract boolean verify() throws Exception;

    static class ClusterVerifyTrigger {
        final PropertyKey _triggerKey;
        final boolean _triggerOnChildDataChange;

        public ClusterVerifyTrigger(PropertyKey triggerKey, boolean triggerOnChildDataChange) {
            this._triggerKey = triggerKey;
            this._triggerOnChildDataChange = triggerOnChildDataChange;
        }
    }
}

