/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.model;

import java.util.ArrayList;
import java.util.List;
import org.guvnor.common.services.project.model.Dependency;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.Repository;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class POM {
    private static final String MODEL_VERSION = "4.0.0";
    private GAV parent;
    private GAV gav;
    private String name;
    private String description;
    private boolean multiModule;
    private List<Dependency> dependencies = new ArrayList<Dependency>();
    private List<Repository> repositories = new ArrayList<Repository>();
    private List<String> modules = new ArrayList<String>();

    public POM() {
        this.gav = new GAV();
    }

    public POM(GAV gav) {
        this(null, null, gav);
    }

    public POM(String name, String description, GAV gav) {
        this.name = name;
        this.description = description;
        this.gav = gav;
        this.multiModule = false;
    }

    public POM(String name, String description, GAV gav, boolean multiModule) {
        this.name = name;
        this.description = description;
        this.gav = gav;
        this.multiModule = multiModule;
    }

    public GAV getGav() {
        return this.gav;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void addRepository(Repository repository) {
        this.repositories.add(repository);
    }

    public List<Repository> getRepositories() {
        return this.repositories;
    }

    public String getModelVersion() {
        return MODEL_VERSION;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public GAV getParent() {
        return this.parent;
    }

    public void setParent(GAV parent) {
        this.parent = parent;
    }

    public List<String> getModules() {
        return this.modules;
    }

    public void setModules(List<String> modules) {
        this.modules = modules;
    }

    public boolean isMultiModule() {
        return this.multiModule;
    }

    public void setMultiModule(boolean multiModule) {
        this.multiModule = multiModule;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        POM pom = (POM)o;
        if (this.multiModule != pom.multiModule) {
            return false;
        }
        if (this.dependencies != null ? !this.dependencies.equals(pom.dependencies) : pom.dependencies != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(pom.description) : pom.description != null) {
            return false;
        }
        if (this.gav != null ? !this.gav.equals(pom.gav) : pom.gav != null) {
            return false;
        }
        if (this.modules != null ? !this.modules.equals(pom.modules) : pom.modules != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(pom.name) : pom.name != null) {
            return false;
        }
        if (this.parent != null ? !this.parent.equals(pom.parent) : pom.parent != null) {
            return false;
        }
        return !(this.repositories != null ? !this.repositories.equals(pom.repositories) : pom.repositories != null);
    }

    public int hashCode() {
        int result = this.parent != null ? this.parent.hashCode() : 0;
        result = ~(~result);
        result = 31 * result + (this.gav != null ? this.gav.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.multiModule ? 1 : 0);
        result = ~(~result);
        result = 31 * result + (this.dependencies != null ? this.dependencies.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.repositories != null ? this.repositories.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.modules != null ? this.modules.hashCode() : 0);
        result = ~(~result);
        return result;
    }
}

