/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.vfs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.uberfire.backend.vfs.FileSystem;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.commons.validation.PortablePreconditions;

public final class FileSystemFactory {
    private FileSystemFactory() {
    }

    public static FileSystem newFS(Map<String, String> roots, Set<String> supportedViews) {
        return new FileSystemImpl(roots, supportedViews);
    }

    @Portable
    public static class FileSystemImpl
    implements FileSystem {
        private List<Path> rootDirectories = null;
        private Set<String> supportedViews = null;

        public FileSystemImpl() {
        }

        public FileSystemImpl(Map<String, String> roots, Set<String> supportedViews) {
            PortablePreconditions.checkNotNull((String)"roots", roots);
            this.rootDirectories = new ArrayList<Path>(roots.size());
            for (Map.Entry<String, String> entry : roots.entrySet()) {
                this.rootDirectories.add(PathFactory.newPath((String)entry.getValue(), (String)entry.getKey()));
            }
            this.supportedViews = new HashSet<String>((Collection)PortablePreconditions.checkNotNull((String)"supportedViews", supportedViews));
        }

        public List<Path> getRootDirectories() {
            return this.rootDirectories;
        }

        public Set<String> supportedFileAttributeViews() {
            return this.supportedViews;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.rootDirectories != null) {
                for (Path rootDirectory : this.rootDirectories) {
                    sb.append(rootDirectory.toString());
                }
            }
            return sb.toString();
        }
    }
}

