/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.util;

import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ContextNotActiveException;
import javax.inject.Inject;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.rpc.SessionInfo;

@ApplicationScoped
public class CommentedOptionFactoryImpl
implements CommentedOptionFactory {
    private static final String UNKNOWN_IDENTITY = "unknown";
    private static final String UNKNOWN_SESSION = "--";
    @Inject
    private User identity;
    @Inject
    private SessionInfo sessionInfo;

    public CommentedOption makeCommentedOption(String commitMessage) {
        return this.makeCommentedOption(commitMessage, this.identity, this.sessionInfo);
    }

    public CommentedOption makeCommentedOption(String commitMessage, User identity, SessionInfo sessionInfo) {
        Date when = new Date();
        CommentedOption co = new CommentedOption(this.getSessionId(sessionInfo), this.getIdentityName(identity), null, commitMessage, when);
        return co;
    }

    protected String getIdentityName(User identity) {
        try {
            return identity != null ? identity.getIdentifier() : UNKNOWN_IDENTITY;
        }
        catch (ContextNotActiveException e) {
            return UNKNOWN_IDENTITY;
        }
    }

    protected String getSessionId(SessionInfo sessionInfo) {
        try {
            return sessionInfo != null ? sessionInfo.getId() : UNKNOWN_SESSION;
        }
        catch (ContextNotActiveException e) {
            return UNKNOWN_SESSION;
        }
    }
}

