/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.xml.PomModel;
import org.drools.compiler.kproject.xml.PomModelGenerator;
import org.kie.api.builder.ReleaseId;
import org.kie.scanner.embedder.MavenProjectLoader;

public class MavenPomModelGenerator
implements PomModelGenerator {
    public PomModel parse(String path, InputStream pomStream) {
        return new MavenModel(MavenProjectLoader.parseMavenPom(pomStream));
    }

    public static class MavenModel
    implements PomModel {
        private final MavenProject mavenProject;
        private final ReleaseId releaseId;
        private final ReleaseId parentReleaseId;
        private final Set<ReleaseId> dependencies;

        public MavenModel(MavenProject mavenProject) {
            this.mavenProject = mavenProject;
            this.releaseId = this.initReleaseId(mavenProject);
            this.parentReleaseId = this.initParentReleaseId(mavenProject);
            this.dependencies = this.initDependencies(mavenProject);
        }

        public MavenProject getMavenProject() {
            return this.mavenProject;
        }

        public ReleaseId getReleaseId() {
            return this.releaseId;
        }

        private ReleaseId initReleaseId(MavenProject mavenProject) {
            return new ReleaseIdImpl(mavenProject.getGroupId(), mavenProject.getArtifactId(), mavenProject.getVersion());
        }

        public ReleaseId getParentReleaseId() {
            return this.parentReleaseId;
        }

        private ReleaseId initParentReleaseId(MavenProject mavenProject) {
            try {
                MavenProject parentProject = mavenProject.getParent();
                if (parentProject != null) {
                    return new ReleaseIdImpl(parentProject.getGroupId(), parentProject.getArtifactId(), parentProject.getVersion());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        public Collection<ReleaseId> getDependencies() {
            return this.dependencies;
        }

        private Set<ReleaseId> initDependencies(MavenProject mavenProject) {
            HashSet<ReleaseId> dependencies = new HashSet<ReleaseId>();
            for (Artifact dep : mavenProject.getArtifacts()) {
                String scope = dep.getScope();
                if ("provided".equals(scope) || "test".equals(scope)) continue;
                dependencies.add((ReleaseId)new ReleaseIdImpl(dep.getGroupId(), dep.getArtifactId(), dep.getVersion()));
            }
            return dependencies;
        }
    }
}

