/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ClusterEvent {
    private static final Logger logger = Logger.getLogger((String)ClusterEvent.class.getName());
    private final String _eventName;
    private final Map<String, Object> _eventAttributeMap;

    public ClusterEvent(String name) {
        this._eventName = name;
        this._eventAttributeMap = new HashMap<String, Object>();
    }

    public void addAttribute(String attrName, Object attrValue) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Adding attribute:" + attrName));
            logger.trace((Object)(" attribute value:" + attrValue));
        }
        this._eventAttributeMap.put(attrName, attrValue);
    }

    public String getName() {
        return this._eventName;
    }

    public <T> T getAttribute(String attrName) {
        Object ret = this._eventAttributeMap.get(attrName);
        if (ret != null) {
            return (T)ret;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("name:" + this._eventName).append("\n");
        for (String key : this._eventAttributeMap.keySet()) {
            sb.append(key).append(":").append(this._eventAttributeMap.get(key)).append("\n");
        }
        return sb.toString();
    }
}

