/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.Channel;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoOutputStream;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.io.WritePendingException;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.CloseableUtils;

public class ChannelAsyncOutputStream
extends CloseableUtils.AbstractInnerCloseable
implements IoOutputStream {
    private final Channel channel;
    private final byte cmd;
    private final AtomicReference<IoWriteFutureImpl> pendingWrite = new AtomicReference();

    public ChannelAsyncOutputStream(Channel channel, byte cmd) {
        this.channel = channel;
        this.cmd = cmd;
    }

    public void onWindowExpanded() throws IOException {
        this.doWriteIfPossible(true);
    }

    public synchronized IoWriteFuture write(Buffer buffer) {
        IoWriteFutureImpl future = new IoWriteFutureImpl(buffer);
        if (this.isClosing()) {
            future.setValue(new IOException("Closed"));
        } else {
            if (!this.pendingWrite.compareAndSet(null, future)) {
                throw new WritePendingException();
            }
            this.doWriteIfPossible(false);
        }
        return future;
    }

    protected Closeable getInnerCloseable() {
        return this.builder().when(this.pendingWrite.get()).build();
    }

    protected synchronized void doWriteIfPossible(boolean resume) {
        final IoWriteFutureImpl future = this.pendingWrite.get();
        if (future != null) {
            Buffer buffer = future.buffer;
            final int total = buffer.available();
            if (total > 0) {
                final int length = Math.min(Math.min(this.channel.getRemoteWindow().getSize(), total), this.channel.getRemoteWindow().getPacketSize());
                if (length > 0) {
                    if (resume) {
                        this.log.debug("Resuming write due to more space available in the remote window");
                    }
                    Buffer buf = this.channel.getSession().createBuffer(this.cmd, length + 12);
                    buf.putInt(this.channel.getRecipient());
                    if (this.cmd == 95) {
                        buf.putInt(1L);
                    }
                    buf.putInt(length);
                    buf.putRawBytes(buffer.array(), buffer.rpos(), length);
                    buffer.rpos(buffer.rpos() + length);
                    this.channel.getRemoteWindow().consume(length);
                    try {
                        this.channel.getSession().writePacket(buf).addListener(new SshFutureListener<IoWriteFuture>(){

                            @Override
                            public void operationComplete(IoWriteFuture f) {
                                if (total > length) {
                                    ChannelAsyncOutputStream.this.doWriteIfPossible(false);
                                } else {
                                    ChannelAsyncOutputStream.this.pendingWrite.compareAndSet(future, null);
                                    future.setValue(true);
                                }
                            }
                        });
                    }
                    catch (IOException e) {
                        future.setValue(e);
                    }
                } else if (!resume) {
                    this.log.debug("Delaying write until space is available in the remote window");
                }
            } else {
                this.pendingWrite.compareAndSet(future, null);
                future.setValue(true);
            }
        }
    }

    public String toString() {
        return "ChannelAsyncOutputStream[" + this.channel + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IoWriteFutureImpl
    extends DefaultSshFuture<IoWriteFuture>
    implements IoWriteFuture {
        final Buffer buffer;

        public IoWriteFutureImpl(Buffer buffer) {
            super(null);
            this.buffer = buffer;
        }

        public Buffer getBuffer() {
            return this.buffer;
        }

        @Override
        public void verify() throws SshException {
            try {
                this.await();
            }
            catch (InterruptedException e) {
                throw new SshException("Interrupted", (Throwable)e);
            }
            if (!this.isWritten()) {
                throw new SshException("Write failed", this.getException());
            }
        }

        @Override
        public boolean isWritten() {
            return this.getValue() instanceof Boolean;
        }

        @Override
        public Throwable getException() {
            Object v = this.getValue();
            if (v instanceof Throwable) {
                return (Throwable)v;
            }
            return null;
        }
    }
}

