/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.validation;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Package;
import org.kie.workbench.common.services.backend.validation.ValidationUtils;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.backend.validation.FileNameValidator;

@ApplicationScoped
public class PackageNameValidator
implements FileNameValidator {
    @Inject
    private KieProjectService projectService;

    public int getPriority() {
        return 1;
    }

    public boolean accept(String fileName) {
        return false;
    }

    public boolean accept(Path path) {
        Package pkg = this.projectService.resolvePackage(path);
        if (pkg == null) {
            return false;
        }
        return pkg.getPackageMainSrcPath().equals(path) || pkg.getPackageMainResourcesPath().equals(path) || pkg.getPackageTestSrcPath().equals(path) || pkg.getPackageTestResourcesPath().equals(path);
    }

    public boolean isValid(String value) {
        Map<String, Boolean> results = this.evaluateIdentifiers(value.split("\\.", -1));
        return !results.containsValue(Boolean.FALSE);
    }

    private Map<String, Boolean> evaluateIdentifiers(String[] identifiers) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(identifiers.length);
        if (identifiers != null && identifiers.length > 0) {
            for (String s : identifiers) {
                result.put(s, ValidationUtils.isJavaIdentifier(s));
            }
        }
        return result;
    }
}

