/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.explorer.backend.server;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.kie.workbench.common.screens.explorer.backend.server.ExplorerServiceHelper;
import org.kie.workbench.common.screens.explorer.model.FolderItem;
import org.kie.workbench.common.screens.explorer.model.FolderListing;
import org.kie.workbench.common.screens.explorer.service.ActiveOptions;
import org.kie.workbench.common.screens.explorer.service.Option;
import org.kie.workbench.common.services.shared.project.KieProjectService;

public class FolderListingResolver {
    private FolderItem selectedItem;
    private Project selectedProject;
    private Package selectedPackage;
    private ExplorerServiceHelper helper;
    private KieProjectService projectService;

    public FolderListingResolver() {
    }

    @Inject
    public FolderListingResolver(KieProjectService projectService) {
        this.projectService = projectService;
    }

    public FolderListing resolve(FolderItem selectedItem, Project selectedProject, Package selectedPackage, ExplorerServiceHelper helper, ActiveOptions options) {
        this.init(selectedItem, selectedProject, selectedPackage, helper);
        return this.getFolderListing(options);
    }

    private void init(FolderItem selectedItem, Project selectedProject, Package selectedPackage, ExplorerServiceHelper helper) {
        this.selectedItem = selectedItem;
        this.selectedProject = selectedProject;
        this.selectedPackage = selectedPackage;
        this.helper = helper;
    }

    private FolderListing getFolderListing(ActiveOptions options) {
        FolderListing result = this.selectedItem == null ? (options.contains(Option.BUSINESS_CONTENT) ? new FolderListing(ExplorerServiceHelper.toFolderItem(this.getDefaultPackage()), this.helper.getItems(this.getDefaultPackage()), this.getSegments()) : this.helper.getFolderListing(this.selectedProject.getRootPath())) : this.helper.getFolderListing(this.selectedItem);
        if (this.selectedPackage != null && result == null) {
            result = new FolderListing(ExplorerServiceHelper.toFolderItem(this.selectedPackage), this.helper.getItems(this.selectedPackage), this.helper.getPackageSegments(this.selectedPackage));
        }
        return result;
    }

    private Package getDefaultPackage() {
        Package defaultPackage = this.selectedPackage == null ? this.projectService.resolveDefaultPackage(this.selectedProject) : this.selectedPackage;
        return defaultPackage;
    }

    private List<FolderItem> getSegments() {
        if (this.selectedPackage == null) {
            return Collections.emptyList();
        }
        return this.helper.getPackageSegments(this.selectedPackage);
    }
}

