/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.Property;
import org.jgroups.auth.AuthToken;
import org.jgroups.auth.X509Token;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.AuthHeader;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.stack.Protocol;

@MBean(description="Provides authentication of joiners, to prevent un-authorized joining of a cluster")
public class AUTH
extends Protocol {
    protected AuthToken auth_token;
    protected static final short GMS_ID = ClassConfigurator.getProtocolId(GMS.class);
    protected final List<UpHandler> up_handlers = new ArrayList<UpHandler>();
    protected Address local_addr;
    protected volatile boolean authenticate_coord = true;

    public AUTH() {
        this.name = "AUTH";
    }

    @Property(description="Do join or merge responses from the coordinator also need to be authenticated")
    public AUTH setAuthCoord(boolean authenticateCoord) {
        this.authenticate_coord = authenticateCoord;
        return this;
    }

    @Property(name="auth_class", description="The fully qualified name of the class implementing the AuthToken interface")
    public void setAuthClass(String class_name) throws Exception {
        Object obj = Class.forName(class_name).newInstance();
        this.auth_token = (AuthToken)obj;
        this.auth_token.setAuth(this);
    }

    public String getAuthClass() {
        return this.auth_token != null ? this.auth_token.getClass().getName() : null;
    }

    public AuthToken getAuthToken() {
        return this.auth_token;
    }

    public AUTH setAuthToken(AuthToken token) {
        this.auth_token = token;
        return this;
    }

    public AUTH register(UpHandler handler) {
        this.up_handlers.add(handler);
        return this;
    }

    public AUTH unregister(UpHandler handler) {
        this.up_handlers.remove(handler);
        return this;
    }

    public Address getAddress() {
        return this.local_addr;
    }

    public PhysicalAddress getPhysicalAddress() {
        return this.getTransport().getPhysicalAddress();
    }

    @Override
    protected List<Object> getConfigurableObjects() {
        LinkedList<Object> retval = new LinkedList<Object>();
        if (this.auth_token != null) {
            retval.add(this.auth_token);
        }
        return retval;
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.auth_token == null) {
            throw new IllegalStateException("no authentication mechanism configured");
        }
        if (this.auth_token instanceof X509Token) {
            X509Token tmp = (X509Token)this.auth_token;
            tmp.setCertificate();
        }
        this.auth_token.init();
    }

    @Override
    public void start() throws Exception {
        super.start();
        if (this.auth_token != null) {
            this.auth_token.start();
        }
    }

    @Override
    public void stop() {
        if (this.auth_token != null) {
            this.auth_token.stop();
        }
        super.stop();
    }

    @Override
    public void destroy() {
        if (this.auth_token != null) {
            this.auth_token.destroy();
        }
        super.destroy();
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                GMS.GmsHeader gms_hdr = AUTH.getGMSHeader(evt);
                if (gms_hdr == null || !this.needsAuthentication(gms_hdr)) break;
                AuthHeader auth_hdr = (AuthHeader)msg.getHeader(this.id);
                if (auth_hdr == null) {
                    throw new IllegalStateException(String.format("found %s from %s but no AUTH header", gms_hdr, msg.src()));
                }
                if (this.handleAuthHeader(gms_hdr, auth_hdr, msg)) break;
                return null;
            }
        }
        if (!this.callUpHandlers(evt)) {
            return null;
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object down(Event evt) {
        GMS.GmsHeader hdr = AUTH.getGMSHeader(evt);
        if (hdr != null && this.needsAuthentication(hdr)) {
            Message msg = (Message)evt.getArg();
            msg.putHeader(this.id, new AuthHeader(this.auth_token));
        }
        if (evt.getType() == 8) {
            this.local_addr = (Address)evt.getArg();
        }
        return this.down_prot.down(evt);
    }

    protected boolean needsAuthentication(GMS.GmsHeader hdr) {
        switch (hdr.getType()) {
            case 1: 
            case 6: 
            case 11: {
                return true;
            }
            case 2: 
            case 7: 
            case 8: {
                return this.authenticate_coord;
            }
        }
        return false;
    }

    protected boolean handleAuthHeader(GMS.GmsHeader gms_hdr, AuthHeader auth_hdr, Message msg) {
        if (this.needsAuthentication(gms_hdr)) {
            if (this.auth_token.authenticate(auth_hdr.getToken(), msg)) {
                return true;
            }
            this.log.warn(String.format("%s: failed to validate AuthHeader (token: %s) from %s; dropping message", this.local_addr, this.auth_token.getClass().getSimpleName(), msg.src()));
            this.sendRejectionMessage(gms_hdr.getType(), msg.getSrc(), "authentication failed");
            return false;
        }
        return true;
    }

    protected void sendRejectionMessage(byte type, Address dest, String error_msg) {
        switch (type) {
            case 1: 
            case 11: {
                this.sendJoinRejectionMessage(dest, error_msg);
                break;
            }
            case 6: {
                this.sendMergeRejectionMessage(dest);
            }
        }
    }

    protected void sendJoinRejectionMessage(Address dest, String error_msg) {
        if (dest == null) {
            return;
        }
        JoinRsp joinRes = new JoinRsp(error_msg);
        Message msg = new Message(dest).putHeader(GMS_ID, new GMS.GmsHeader(2)).setBuffer(GMS.marshal(joinRes));
        if (this.authenticate_coord) {
            msg.putHeader(this.id, new AuthHeader(this.auth_token));
        }
        this.down_prot.down(new Event(1, msg));
    }

    protected void sendMergeRejectionMessage(Address dest) {
        GMS.GmsHeader hdr = new GMS.GmsHeader(7);
        hdr.setMergeRejected(true);
        Message msg = new Message(dest).setFlag(Message.Flag.OOB).putHeader(GMS_ID, hdr);
        if (this.authenticate_coord) {
            msg.putHeader(this.id, new AuthHeader(this.auth_token));
        }
        this.log.debug("merge response=" + hdr);
        this.down_prot.down(new Event(1, msg));
    }

    protected boolean callUpHandlers(Event evt) {
        boolean pass_up = true;
        for (UpHandler handler : this.up_handlers) {
            if (handler.handleUpEvent(evt)) continue;
            pass_up = false;
        }
        return pass_up;
    }

    protected static GMS.GmsHeader getGMSHeader(Event evt) {
        return evt.getType() == 1 ? AUTH.getGMSHeader((Message)evt.getArg()) : null;
    }

    protected static GMS.GmsHeader getGMSHeader(Message msg) {
        Header hdr = msg.getHeader(GMS_ID);
        if (hdr instanceof GMS.GmsHeader) {
            return (GMS.GmsHeader)hdr;
        }
        return null;
    }

    public static interface UpHandler {
        public boolean handleUpEvent(Event var1);
    }
}

