/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.UnmergedPathException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckoutCommand
extends GitCommand<Ref> {
    private String name;
    private boolean force = false;
    private boolean createBranch = false;
    private boolean orphan = false;
    private CreateBranchCommand.SetupUpstreamMode upstreamMode;
    private String startPoint = null;
    private RevCommit startCommit;
    private Stage checkoutStage = null;
    private CheckoutResult status;
    private List<String> paths = new LinkedList<String>();
    private boolean checkoutAllPaths;

    protected CheckoutCommand(Repository repo) {
        super(repo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Ref call() throws GitAPIException, RefAlreadyExistsException, RefNotFoundException, InvalidRefNameException, CheckoutConflictException {
        Ref ref;
        block30: {
            Ref ref2;
            block29: {
                this.checkCallable();
                try {
                    try {
                        RefUpdate.Result updateResult;
                        DirCacheCheckout dco;
                        ObjectId branch;
                        this.processOptions();
                        if (this.checkoutAllPaths || !this.paths.isEmpty()) {
                            this.checkoutPaths();
                            this.status = new CheckoutResult(CheckoutResult.Status.OK, this.paths);
                            this.setCallable(false);
                            Ref ref3 = null;
                            Object var19_4 = null;
                            if (this.status != null) return ref3;
                            this.status = CheckoutResult.ERROR_RESULT;
                            return ref3;
                        }
                        if (this.createBranch) {
                            Git git = new Git(this.repo);
                            CreateBranchCommand command = git.branchCreate();
                            command.setName(this.name);
                            if (this.startCommit != null) {
                                command.setStartPoint(this.startCommit);
                            } else {
                                command.setStartPoint(this.startPoint);
                            }
                            if (this.upstreamMode != null) {
                                command.setUpstreamMode(this.upstreamMode);
                            }
                            command.call();
                        }
                        Ref headRef = this.repo.getRef("HEAD");
                        String shortHeadRef = this.getShortBranchName(headRef);
                        String refLogMessage = "checkout: moving from " + shortHeadRef;
                        if (this.orphan) {
                            if (this.startPoint == null && this.startCommit == null) {
                                RefUpdate.Result r = this.repo.updateRef("HEAD").link(this.getBranchName());
                                if (!EnumSet.of(RefUpdate.Result.NEW, RefUpdate.Result.FORCED).contains((Object)r)) {
                                    throw new JGitInternalException(MessageFormat.format(JGitText.get().checkoutUnexpectedResult, r.name()));
                                }
                                this.status = CheckoutResult.NOT_TRIED_RESULT;
                                ref2 = this.repo.getRef("HEAD");
                                break block29;
                            }
                            branch = this.getStartPointObjectId();
                        } else {
                            branch = this.repo.resolve(this.name);
                            if (branch == null) {
                                throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, this.name));
                            }
                        }
                        RevWalk revWalk = new RevWalk(this.repo);
                        ObjectId headId = headRef.getObjectId();
                        RevCommit headCommit = headId == null ? null : revWalk.parseCommit(headId);
                        RevCommit newCommit = revWalk.parseCommit(branch);
                        RevTree headTree = headCommit == null ? null : headCommit.getTree();
                        DirCache dc = this.repo.lockDirCache();
                        try {
                            dco = new DirCacheCheckout(this.repo, headTree, dc, newCommit.getTree());
                            dco.setFailOnConflict(true);
                            try {
                                dco.checkout();
                            }
                            catch (org.eclipse.jgit.errors.CheckoutConflictException e) {
                                this.status = new CheckoutResult(CheckoutResult.Status.CONFLICTS, dco.getConflicts());
                                throw new CheckoutConflictException(dco.getConflicts(), e);
                            }
                            Object var14_22 = null;
                            dc.unlock();
                        }
                        catch (Throwable throwable) {
                            Object var14_23 = null;
                            dc.unlock();
                            throw throwable;
                        }
                        Ref ref4 = this.repo.getRef(this.name);
                        if (ref4 != null && !ref4.getName().startsWith("refs/heads/")) {
                            ref4 = null;
                        }
                        String toName = Repository.shortenRefName(this.name);
                        RefUpdate refUpdate = this.repo.updateRef("HEAD", ref4 == null);
                        refUpdate.setForceUpdate(this.force);
                        refUpdate.setRefLogMessage(refLogMessage + " to " + toName, false);
                        if (ref4 != null) {
                            updateResult = refUpdate.link(ref4.getName());
                        } else if (this.orphan) {
                            updateResult = refUpdate.link(this.getBranchName());
                            ref4 = this.repo.getRef("HEAD");
                        } else {
                            refUpdate.setNewObjectId(newCommit);
                            updateResult = refUpdate.forceUpdate();
                        }
                        this.setCallable(false);
                        boolean ok = false;
                        switch (updateResult) {
                            case NEW: {
                                ok = true;
                                break;
                            }
                            case NO_CHANGE: 
                            case FAST_FORWARD: 
                            case FORCED: {
                                ok = true;
                                break;
                            }
                        }
                        if (!ok) {
                            throw new JGitInternalException(MessageFormat.format(JGitText.get().checkoutUnexpectedResult, updateResult.name()));
                        }
                        this.status = !dco.getToBeDeleted().isEmpty() ? new CheckoutResult(CheckoutResult.Status.NONDELETED, dco.getToBeDeleted()) : new CheckoutResult(new ArrayList<String>(dco.getUpdated().keySet()), dco.getRemoved());
                        ref = ref4;
                        break block30;
                    }
                    catch (IOException ioe) {
                        throw new JGitInternalException(ioe.getMessage(), ioe);
                    }
                }
                catch (Throwable throwable) {
                    Object var19_7 = null;
                    if (this.status != null) throw throwable;
                    this.status = CheckoutResult.ERROR_RESULT;
                    throw throwable;
                }
            }
            Object var19_5 = null;
            if (this.status != null) return ref2;
            this.status = CheckoutResult.ERROR_RESULT;
            return ref2;
        }
        Object var19_6 = null;
        if (this.status != null) return ref;
        this.status = CheckoutResult.ERROR_RESULT;
        return ref;
    }

    private String getShortBranchName(Ref headRef) {
        if (headRef.getTarget().getName().equals(headRef.getName())) {
            return headRef.getTarget().getObjectId().getName();
        }
        return Repository.shortenRefName(headRef.getTarget().getName());
    }

    public CheckoutCommand addPath(String path) {
        this.checkCallable();
        this.paths.add(path);
        return this;
    }

    public CheckoutCommand setAllPaths(boolean all) {
        this.checkoutAllPaths = all;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CheckoutCommand checkoutPaths() throws IOException, RefNotFoundException {
        RevWalk revWalk = new RevWalk(this.repo);
        DirCache dc = this.repo.lockDirCache();
        try {
            TreeWalk treeWalk = new TreeWalk(revWalk.getObjectReader());
            treeWalk.setRecursive(true);
            if (!this.checkoutAllPaths) {
                treeWalk.setFilter(PathFilterGroup.createFromStrings(this.paths));
            }
            try {
                if (this.isCheckoutIndex()) {
                    this.checkoutPathsFromIndex(treeWalk, dc);
                } else {
                    RevCommit commit = revWalk.parseCommit(this.getStartPointObjectId());
                    this.checkoutPathsFromCommit(treeWalk, dc, commit);
                }
                Object var6_5 = null;
                treeWalk.release();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                treeWalk.release();
                throw throwable;
            }
            Object var8_8 = null;
            dc.unlock();
            revWalk.release();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            dc.unlock();
            revWalk.release();
            throw throwable;
        }
        return this;
    }

    private void checkoutPathsFromIndex(TreeWalk treeWalk, DirCache dc) throws IOException {
        DirCacheIterator dci = new DirCacheIterator(dc);
        treeWalk.addTree(dci);
        String previousPath = null;
        final ObjectReader r = treeWalk.getObjectReader();
        DirCacheEditor editor = dc.editor();
        while (treeWalk.next()) {
            String path = treeWalk.getPathString();
            if (path.equals(previousPath)) continue;
            editor.add(new DirCacheEditor.PathEdit(path){

                /*
                 * Enabled aggressive block sorting
                 */
                public void apply(DirCacheEntry ent) {
                    int stage = ent.getStage();
                    if (stage <= 0) {
                        CheckoutCommand.this.checkoutPath(ent, r);
                        return;
                    }
                    if (CheckoutCommand.this.checkoutStage != null) {
                        if (stage != CheckoutCommand.this.checkoutStage.number) return;
                        CheckoutCommand.this.checkoutPath(ent, r);
                        return;
                    }
                    UnmergedPathException e = new UnmergedPathException(ent);
                    throw new JGitInternalException(e.getMessage(), e);
                }
            });
            previousPath = path;
        }
        editor.commit();
    }

    private void checkoutPathsFromCommit(TreeWalk treeWalk, DirCache dc, RevCommit commit) throws IOException {
        treeWalk.addTree(commit.getTree());
        final ObjectReader r = treeWalk.getObjectReader();
        DirCacheEditor editor = dc.editor();
        while (treeWalk.next()) {
            final ObjectId blobId = treeWalk.getObjectId(0);
            final FileMode mode = treeWalk.getFileMode(0);
            editor.add(new DirCacheEditor.PathEdit(treeWalk.getPathString()){

                public void apply(DirCacheEntry ent) {
                    ent.setObjectId(blobId);
                    ent.setFileMode(mode);
                    CheckoutCommand.this.checkoutPath(ent, r);
                }
            });
        }
        editor.commit();
    }

    private void checkoutPath(DirCacheEntry entry, ObjectReader reader) {
        try {
            DirCacheCheckout.checkoutEntry(this.repo, entry, reader);
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().checkoutConflictWithFile, entry.getPathString()), e);
        }
    }

    private boolean isCheckoutIndex() {
        return this.startCommit == null && this.startPoint == null;
    }

    private ObjectId getStartPointObjectId() throws AmbiguousObjectException, RefNotFoundException, IOException {
        if (this.startCommit != null) {
            return this.startCommit.getId();
        }
        String startPointOrHead = this.startPoint != null ? this.startPoint : "HEAD";
        ObjectId result = this.repo.resolve(startPointOrHead);
        if (result == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, startPointOrHead));
        }
        return result;
    }

    private void processOptions() throws InvalidRefNameException, RefAlreadyExistsException, IOException {
        Ref refToCheck;
        if ((!this.checkoutAllPaths && this.paths.isEmpty() || this.orphan) && (this.name == null || !Repository.isValidRefName("refs/heads/" + this.name))) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().branchNameInvalid, this.name == null ? "<null>" : this.name));
        }
        if (this.orphan && (refToCheck = this.repo.getRef(this.getBranchName())) != null) {
            throw new RefAlreadyExistsException(MessageFormat.format(JGitText.get().refAlreadyExists, this.name));
        }
    }

    private String getBranchName() {
        if (this.name.startsWith("refs/")) {
            return this.name;
        }
        return "refs/heads/" + this.name;
    }

    public CheckoutCommand setName(String name) {
        this.checkCallable();
        this.name = name;
        return this;
    }

    public CheckoutCommand setCreateBranch(boolean createBranch) {
        this.checkCallable();
        this.createBranch = createBranch;
        return this;
    }

    public CheckoutCommand setOrphan(boolean orphan) {
        this.checkCallable();
        this.orphan = orphan;
        return this;
    }

    public CheckoutCommand setForce(boolean force) {
        this.checkCallable();
        this.force = force;
        return this;
    }

    public CheckoutCommand setStartPoint(String startPoint) {
        this.checkCallable();
        this.startPoint = startPoint;
        this.startCommit = null;
        this.checkOptions();
        return this;
    }

    public CheckoutCommand setStartPoint(RevCommit startCommit) {
        this.checkCallable();
        this.startCommit = startCommit;
        this.startPoint = null;
        this.checkOptions();
        return this;
    }

    public CheckoutCommand setUpstreamMode(CreateBranchCommand.SetupUpstreamMode mode) {
        this.checkCallable();
        this.upstreamMode = mode;
        return this;
    }

    public CheckoutCommand setStage(Stage stage) {
        this.checkCallable();
        this.checkoutStage = stage;
        this.checkOptions();
        return this;
    }

    public CheckoutResult getResult() {
        if (this.status == null) {
            return CheckoutResult.NOT_TRIED_RESULT;
        }
        return this.status;
    }

    private void checkOptions() {
        if (this.checkoutStage != null && !this.isCheckoutIndex()) {
            throw new IllegalStateException("Checking out ours/theirs is only possible when checking out index, not when switching branches.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        BASE(1),
        OURS(2),
        THEIRS(3);

        private final int number;

        private Stage(int number) {
            this.number = number;
        }
    }
}

