/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.impl.authz;

import java.util.Collection;
import java.util.Iterator;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.exception.UnauthorizedException;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceManager;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.ProfileDecisionManager;
import org.uberfire.security.authz.ResourceDecisionManager;
import org.uberfire.security.authz.VotingStrategy;

public class DefaultAuthorizationManager
implements AuthorizationManager {
    private final Collection<ResourceDecisionManager> decisionManagers;
    private final ResourceManager resourceManager;
    private final VotingStrategy votingStrategy;
    private final ProfileDecisionManager profileDecisionManager;

    public DefaultAuthorizationManager(Collection<ResourceDecisionManager> decisionManagers, ResourceManager resourceManager, VotingStrategy votingStrategy, ProfileDecisionManager profileDecisionManager) {
        this.votingStrategy = (VotingStrategy)PortablePreconditions.checkNotNull((String)"votingStrategy", (Object)votingStrategy);
        this.profileDecisionManager = profileDecisionManager;
        this.decisionManagers = (Collection)PortablePreconditions.checkNotNull((String)"decisionManagers", decisionManagers);
        this.resourceManager = (ResourceManager)PortablePreconditions.checkNotNull((String)"resourceManagers", (Object)resourceManager);
    }

    public boolean supports(Resource resource) {
        return this.resourceManager.supports(resource);
    }

    public boolean authorize(final Resource resource, final User user) throws UnauthorizedException {
        if (this.decisionManagers.isEmpty()) {
            return true;
        }
        if (!this.resourceManager.requiresAuthentication(resource)) {
            return true;
        }
        PortablePreconditions.checkNotNull((String)"subject", (Object)user);
        Iterable<AuthorizationResult> results = new Iterable<AuthorizationResult>(){

            @Override
            public Iterator<AuthorizationResult> iterator() {
                final Iterator decisionManagerIterator = DefaultAuthorizationManager.this.decisionManagers.iterator();
                return new Iterator<AuthorizationResult>(){

                    @Override
                    public boolean hasNext() {
                        return decisionManagerIterator.hasNext();
                    }

                    @Override
                    public AuthorizationResult next() {
                        ResourceDecisionManager resourceDecisionManager = (ResourceDecisionManager)decisionManagerIterator.next();
                        return resourceDecisionManager.decide(resource, user, DefaultAuthorizationManager.this.profileDecisionManager);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Remove not supported.");
                    }
                };
            }
        };
        AuthorizationResult finalResult = this.votingStrategy.vote(results);
        return finalResult.equals(AuthorizationResult.ACCESS_ABSTAIN) || finalResult.equals(AuthorizationResult.ACCESS_GRANTED);
    }

    public String toString() {
        return "DefaultAuthorizationManager [decisionManagers=" + this.decisionManagers + ", resourceManager=" + this.resourceManager + ", votingStrategy=" + this.votingStrategy + ", profileDecisionManager=" + this.profileDecisionManager + "]";
    }
}

