/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.io.impl.cluster.helix;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.helix.Criteria;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixManagerFactory;
import org.apache.helix.InstanceType;
import org.apache.helix.NotificationContext;
import org.apache.helix.messaging.handling.HelixTaskResult;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.messaging.handling.MessageHandlerFactory;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.Message;
import org.apache.helix.participant.statemachine.StateModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.cluster.ClusterService;
import org.uberfire.commons.data.Pair;
import org.uberfire.commons.lifecycle.PriorityDisposable;
import org.uberfire.commons.lifecycle.PriorityDisposableRegistry;
import org.uberfire.commons.message.AsyncCallback;
import org.uberfire.commons.message.MessageHandler;
import org.uberfire.commons.message.MessageHandlerResolver;
import org.uberfire.commons.message.MessageType;
import org.uberfire.io.impl.cluster.ClusterMessageType;
import org.uberfire.io.impl.cluster.helix.LockTransitionalFactory;

public class ClusterServiceHelix
implements ClusterService {
    private static final AtomicInteger counter = new AtomicInteger(0);
    private static final Logger logger = LoggerFactory.getLogger(ClusterServiceHelix.class);
    private final String clusterName;
    private final String instanceName;
    private final HelixManager participantManager;
    private final String resourceName;
    private final Map<String, MessageHandlerResolver> messageHandlerResolver = new ConcurrentHashMap<String, MessageHandlerResolver>();
    private final ReentrantLock lock = new ReentrantLock(true);

    public ClusterServiceHelix(String clusterName, String zkAddress, String instanceName, String resourceName, MessageHandlerResolver messageHandlerResolver) {
        this.clusterName = clusterName;
        this.instanceName = instanceName;
        this.resourceName = resourceName;
        this.addMessageHandlerResolver(messageHandlerResolver);
        this.participantManager = this.getZkHelixManager(clusterName, zkAddress, instanceName);
        PriorityDisposableRegistry.register((PriorityDisposable)this);
        this.start();
    }

    HelixManager getZkHelixManager(String clusterName, String zkAddress, String instanceName) {
        return HelixManagerFactory.getZKHelixManager((String)clusterName, (String)instanceName, (InstanceType)InstanceType.PARTICIPANT, (String)zkAddress);
    }

    public void addMessageHandlerResolver(MessageHandlerResolver resolver) {
        if (resolver != null) {
            this.messageHandlerResolver.put(resolver.getServiceId(), resolver);
        }
    }

    void start() {
        try {
            this.participantManager.getMessagingService().registerMessageHandlerFactory(Message.MessageType.USER_DEFINE_MSG.toString(), new MessageHandlerResolverWrapper().convert());
            this.participantManager.getStateMachineEngine().registerStateModelFactory("LeaderStandby", (StateModelFactory)new LockTransitionalFactory());
            this.participantManager.connect();
            this.offlinePartition();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    String getNodeStatus() {
        String partition = this.resourceName + "_0";
        ExternalView view = this.getResourceExternalView();
        if (this.clusterIsNotSetYet(view, partition)) {
            return "OFFLINE";
        }
        Map stateMap = view.getStateMap(partition);
        return (String)stateMap.get(this.instanceName);
    }

    ExternalView getResourceExternalView() {
        return this.participantManager.getClusterManagmentTool().getResourceExternalView(this.clusterName, this.resourceName);
    }

    private boolean clusterIsNotSetYet(ExternalView view, String partition) {
        if (view == null) {
            return true;
        }
        Map stateMap = view.getStateMap(partition);
        return stateMap == null || stateMap.get(this.instanceName) == null;
    }

    public void dispose() {
        if (this.participantManager != null && this.participantManager.isConnected()) {
            this.participantManager.disconnect();
        }
    }

    public void onStart(Runnable runnable) {
        runnable.run();
    }

    public int getHoldCount() {
        return this.lock.getHoldCount();
    }

    private void offlinePartition() {
        if ("OFFLINE".equals(this.getNodeStatus())) {
            return;
        }
        this.participantManager.getClusterManagmentTool().enablePartition(false, this.clusterName, this.instanceName, this.resourceName, Arrays.asList(this.resourceName + "_0"));
        while (!"OFFLINE".equals(this.getNodeStatus())) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void enablePartition() {
        if ("LEADER".equals(this.getNodeStatus())) {
            return;
        }
        this.participantManager.getClusterManagmentTool().enablePartition(true, this.clusterName, this.instanceName, this.resourceName, Arrays.asList(this.resourceName + "_0"));
        while (!"LEADER".equals(this.getNodeStatus())) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void disablePartition() {
        String nodeStatus = this.getNodeStatus();
        if ("STANDBY".equals(nodeStatus) || "OFFLINE".equals(nodeStatus)) {
            return;
        }
        this.participantManager.getClusterManagmentTool().enablePartition(false, this.clusterName, this.instanceName, this.resourceName, Arrays.asList(this.resourceName + "_0"));
        while (!"STANDBY".equals(nodeStatus) && !"OFFLINE".equals(nodeStatus)) {
            try {
                Thread.sleep(10L);
                nodeStatus = this.getNodeStatus();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void lock() {
        this.lock.lock();
        this.enablePartition();
    }

    public void unlock() {
        this.disablePartition();
        this.lock.unlock();
    }

    public void broadcastAndWait(String serviceId, MessageType type, Map<String, String> content, int timeOut) {
        this.participantManager.getMessagingService().sendAndWait(this.buildCriteria(), this.buildMessage(serviceId, type, content), new org.apache.helix.messaging.AsyncCallback(timeOut){

            public void onTimeOut() {
            }

            public void onReplyMessage(Message message) {
            }
        }, timeOut);
    }

    public void broadcastAndWait(String serviceId, MessageType type, Map<String, String> content, int timeOut, final AsyncCallback callback) {
        int msg = this.participantManager.getMessagingService().sendAndWait(this.buildCriteria(), this.buildMessage(serviceId, type, content), new org.apache.helix.messaging.AsyncCallback(){

            public void onTimeOut() {
                callback.onTimeOut();
            }

            public void onReplyMessage(Message message) {
                MessageType type = ClusterServiceHelix.this.buildMessageTypeFromReply(message);
                Map map = ClusterServiceHelix.this.getMessageContentFromReply(message);
                callback.onReply(type, map);
            }
        }, timeOut);
        if (msg == 0) {
            callback.onTimeOut();
        }
    }

    public void broadcast(String serviceId, MessageType type, Map<String, String> content) {
        this.participantManager.getMessagingService().send(this.buildCriteria(), this.buildMessage(serviceId, type, content));
    }

    public void broadcast(String serviceId, MessageType type, Map<String, String> content, int timeOut, final AsyncCallback callback) {
        this.participantManager.getMessagingService().send(this.buildCriteria(), this.buildMessage(serviceId, type, content), new org.apache.helix.messaging.AsyncCallback(){

            public void onTimeOut() {
                callback.onTimeOut();
            }

            public void onReplyMessage(Message message) {
                MessageType type = ClusterServiceHelix.this.buildMessageTypeFromReply(message);
                Map map = ClusterServiceHelix.this.getMessageContent(message);
                callback.onReply(type, map);
            }
        }, timeOut);
    }

    public void sendTo(String serviceId, String resourceId, MessageType type, Map<String, String> content) {
        this.participantManager.getMessagingService().send(this.buildCriteria(resourceId), this.buildMessage(serviceId, type, content));
    }

    private Criteria buildCriteria(final String resourceId) {
        return new Criteria(){
            {
                this.setInstanceName(resourceId);
                this.setRecipientInstanceType(InstanceType.PARTICIPANT);
                this.setResource(ClusterServiceHelix.this.resourceName);
                this.setSelfExcluded(true);
                this.setSessionSpecific(true);
            }
        };
    }

    private Criteria buildCriteria() {
        return this.buildCriteria("%");
    }

    private Message buildMessage(final String serviceId, final MessageType type, final Map<String, String> content) {
        return new Message(Message.MessageType.USER_DEFINE_MSG, UUID.randomUUID().toString()){
            {
                super(x0, x1);
                this.setMsgState(Message.MessageState.NEW);
                this.getRecord().setMapField("content", content);
                this.getRecord().setSimpleField("serviceId", serviceId);
                this.getRecord().setSimpleField("type", type.toString());
                this.getRecord().setSimpleField("origin", ClusterServiceHelix.this.instanceName);
            }
        };
    }

    public int priority() {
        return -2147483448;
    }

    private MessageType buildMessageType(final String _type) {
        MessageType type;
        if (_type == null) {
            return null;
        }
        try {
            type = ClusterMessageType.valueOf(_type);
        }
        catch (Exception ex) {
            type = new MessageType(){

                public String toString() {
                    return _type;
                }

                public int hashCode() {
                    return _type.hashCode();
                }
            };
        }
        return type;
    }

    private MessageType buildMessageTypeFromReply(Message message) {
        Map result = message.getRecord().getMapField(Message.Attributes.MESSAGE_RESULT.toString());
        return this.buildMessageType((String)result.get("type"));
    }

    private Map<String, String> getMessageContent(Message message) {
        return message.getRecord().getMapField("content");
    }

    private Map<String, String> getMessageContentFromReply(final Message message) {
        return new HashMap<String, String>(){
            {
                for (Map.Entry field : message.getRecord().getMapField(Message.Attributes.MESSAGE_RESULT.toString()).entrySet()) {
                    if (((String)field.getKey()).equals("serviceId") || ((String)field.getKey()).equals("origin") || ((String)field.getKey()).equals("type")) continue;
                    this.put(field.getKey(), field.getValue());
                }
            }
        };
    }

    class MessageHandlerResolverWrapper {
        MessageHandlerResolverWrapper() {
        }

        MessageHandlerFactory convert() {
            return new MessageHandlerFactory(){

                public org.apache.helix.messaging.handling.MessageHandler createHandler(Message message, NotificationContext context) {
                    return new org.apache.helix.messaging.handling.MessageHandler(message, context){

                        public HelixTaskResult handleMessage() throws InterruptedException {
                            try {
                                final String serviceId = this._message.getRecord().getSimpleField("serviceId");
                                MessageType type = ClusterServiceHelix.this.buildMessageType(this._message.getRecord().getSimpleField("type"));
                                Map map = ClusterServiceHelix.this.getMessageContent(this._message);
                                MessageHandlerResolver resolver = (MessageHandlerResolver)ClusterServiceHelix.this.messageHandlerResolver.get(serviceId);
                                if (resolver == null) {
                                    System.err.println("serviceId not found '" + serviceId + "'");
                                    return new HelixTaskResult(){
                                        {
                                            this.setSuccess(false);
                                            this.setMessage("Can't find resolver");
                                        }
                                    };
                                }
                                MessageHandler handler = resolver.resolveHandler(serviceId, type);
                                if (handler == null) {
                                    System.err.println("handler not found for '" + serviceId + "' and type '" + type.toString() + "'");
                                    return new HelixTaskResult(){
                                        {
                                            this.setSuccess(false);
                                            this.setMessage("Can't find handler.");
                                        }
                                    };
                                }
                                final Pair result = handler.handleMessage(type, map);
                                if (result == null) {
                                    return new HelixTaskResult(){
                                        {
                                            this.setSuccess(true);
                                        }
                                    };
                                }
                                return new HelixTaskResult(){
                                    {
                                        this.setSuccess(true);
                                        this.getTaskResultMap().put("serviceId", serviceId);
                                        this.getTaskResultMap().put("type", ((MessageType)result.getK1()).toString());
                                        this.getTaskResultMap().put("origin", ClusterServiceHelix.this.instanceName);
                                        for (Map.Entry entry : ((Map)result.getK2()).entrySet()) {
                                            this.getTaskResultMap().put(entry.getKey(), entry.getValue());
                                        }
                                    }
                                };
                            }
                            catch (Throwable e) {
                                logger.error("Error while processing cluster message", e);
                                return new HelixTaskResult(){
                                    {
                                        this.setSuccess(false);
                                        this.setMessage(e.getMessage());
                                        this.setException(new RuntimeException(e));
                                    }
                                };
                            }
                        }

                        public void onError(Exception e, MessageHandler.ErrorCode code, MessageHandler.ErrorType type) {
                        }
                    };
                }

                public String getMessageType() {
                    return Message.MessageType.USER_DEFINE_MSG.toString();
                }

                public void reset() {
                }
            };
        }
    }
}

