/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.guvnor.common.services.project.model.GAV;

public class MavenLocalRepositoryUtils {
    public static File getRepositoryPath(GAV gav) throws IOException {
        File tempLocalRepositoryBasePath = MavenLocalRepositoryUtils.createTempDirectory("m2-" + MavenLocalRepositoryUtils.toFileName(gav));
        return tempLocalRepositoryBasePath;
    }

    private static String toFileName(GAV gav) {
        StringBuilder sb = new StringBuilder();
        sb.append("m2-").append(gav.getGroupId() + "-" + gav.getArtifactId() + "-" + gav.getVersion());
        return sb.toString();
    }

    public static void tearDownMavenRepository(File m2Folder) {
        FileUtils.deleteQuietly((File)m2Folder);
    }

    public static File createTempDirectory(String name) throws IOException {
        File temp = File.createTempFile(name, Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }
}

