/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.EncryptBase;
import org.jgroups.protocols.EncryptHeader;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.util.AsciiString;
import org.jgroups.util.Util;

@MBean(description="Asymmetric encryption protocol. The secret key for encryption and decryption of messages is fetched from a key server (the coordinator) via asymmetric encryption")
public class ASYM_ENCRYPT
extends EncryptBase {
    protected static final short GMS_ID = ClassConfigurator.getProtocolId(GMS.class);
    @Property(description="When a member leaves the view, change the secret key, preventing old members from eavesdropping", writable=false)
    protected boolean change_key_on_leave = true;
    protected volatile Address key_server_addr;
    @ManagedAttribute(description="True if this member is the current key server, false otherwise")
    protected volatile boolean is_key_server;
    protected KeyPair key_pair;
    protected Cipher asym_cipher;
    @ManagedAttribute(description="whether or not to queue received messages (until the secret key was received)")
    protected volatile boolean queue_up_msgs = true;
    protected final BlockingQueue<Message> up_queue = new ArrayBlockingQueue<Message>(100);
    protected volatile long last_key_request;

    public KeyPair keyPair() {
        return this.key_pair;
    }

    public Cipher asymCipher() {
        return this.asym_cipher;
    }

    public Address keyServerAddr() {
        return this.key_server_addr;
    }

    public ASYM_ENCRYPT keyServerAddr(Address key_srv) {
        this.key_server_addr = key_srv;
        return this;
    }

    @ManagedAttribute(description="Number of received messages currently queued")
    public int numQueuedMessages() {
        return this.up_queue.size();
    }

    @ManagedOperation(description="Triggers a request for the secret key to the current keyserver")
    public void sendKeyRequest() {
        if (this.key_server_addr == null) {
            this.log.error(String.format("%s: key server is currently not set", this.local_addr));
            return;
        }
        this.sendKeyRequest(this.key_server_addr);
    }

    @Override
    public void init() throws Exception {
        this.initKeyPair();
        super.init();
    }

    @Override
    public void stop() {
        this.drainUpQueue();
        super.stop();
    }

    @Override
    public Object down(Event evt) {
        Message msg;
        if (evt.type() == 1 && ASYM_ENCRYPT.skip(msg = (Message)evt.arg())) {
            return this.down_prot.down(evt);
        }
        return super.down(evt);
    }

    @Override
    public Object up(Event evt) {
        Message msg;
        if (evt.type() == 1 && ASYM_ENCRYPT.skip(msg = (Message)evt.arg())) {
            return this.up_prot.up(evt);
        }
        return super.up(evt);
    }

    protected static boolean skip(Message msg) {
        GMS.GmsHeader hdr = (GMS.GmsHeader)msg.getHeader(GMS_ID);
        if (hdr == null) {
            return false;
        }
        switch (hdr.getType()) {
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected Object handleUpEvent(Message msg, EncryptHeader hdr) {
        switch (hdr.type()) {
            case 2: {
                this.handleSecretKeyRequest(msg);
                break;
            }
            case 4: {
                this.handleSecretKeyResponse(msg, hdr.version());
                break;
            }
            default: {
                this.log.warn(String.format("%s: received unknown encrypt header of type %d", this.local_addr, hdr.type()));
            }
        }
        return null;
    }

    @Override
    protected boolean process(Message msg) {
        if (this.queue_up_msgs || this.secret_key == null) {
            this.up_queue.offer(msg);
            this.log.trace(String.format("%s: queuing %s message from %s as secret key hasn't been retrieved from keyserver %s yet, hdrs: %s", this.local_addr, msg.dest() == null ? "mcast" : "unicast", msg.src(), this.key_server_addr, msg.printHeaders()));
            if (this.last_key_request == 0L || System.currentTimeMillis() - this.last_key_request > 2000L) {
                this.last_key_request = System.currentTimeMillis();
                this.sendKeyRequest();
            }
            return false;
        }
        return true;
    }

    protected void handleSecretKeyRequest(Message msg) {
        if (!this.inView(msg.src(), "%s: key requester %s is not in current view %s; ignoring key request")) {
            return;
        }
        this.log.debug(String.format("%s: received key request from %s", this.local_addr, msg.getSrc()));
        try {
            PublicKey tmpKey = this.generatePubKey(msg.getBuffer());
            this.sendSecretKey(this.secret_key, tmpKey, msg.getSrc());
        }
        catch (Exception e) {
            this.log.warn(String.format("%s: unable to reconstitute peer's public key", this.local_addr));
        }
    }

    protected void handleSecretKeyResponse(Message msg, byte[] key_version) {
        if (!this.inView(msg.src(), "%s: ignoring secret key sent by %s which is not in current view %s")) {
            return;
        }
        try {
            SecretKeySpec tmp = this.decodeKey(msg.getBuffer());
            if (tmp == null) {
                this.sendKeyRequest(this.key_server_addr);
            } else {
                this.log.debug(String.format("%s: received secret key from keyserver %s", this.local_addr, msg.getSrc()));
                this.setKeys(tmp, key_version);
            }
        }
        catch (Exception e) {
            this.log.warn(this.local_addr + ": unable to process received public key", e);
        }
    }

    protected SecretKey createSecretKey() throws Exception {
        KeyGenerator keyGen = null;
        keyGen = this.provider != null && !this.provider.trim().isEmpty() ? KeyGenerator.getInstance(ASYM_ENCRYPT.getAlgorithm(this.sym_algorithm), this.provider) : KeyGenerator.getInstance(ASYM_ENCRYPT.getAlgorithm(this.sym_algorithm));
        keyGen.init(this.sym_keylength);
        return keyGen.generateKey();
    }

    protected void initKeyPair() throws Exception {
        KeyPairGenerator KpairGen = null;
        KpairGen = this.provider != null && !this.provider.trim().isEmpty() ? KeyPairGenerator.getInstance(ASYM_ENCRYPT.getAlgorithm(this.asym_algorithm), this.provider) : KeyPairGenerator.getInstance(ASYM_ENCRYPT.getAlgorithm(this.asym_algorithm));
        KpairGen.initialize(this.asym_keylength, new SecureRandom());
        this.key_pair = KpairGen.generateKeyPair();
        this.asym_cipher = this.provider != null && !this.provider.trim().isEmpty() ? Cipher.getInstance(this.asym_algorithm, this.provider) : Cipher.getInstance(this.asym_algorithm);
        this.asym_cipher.init(2, this.key_pair.getPrivate());
    }

    @Override
    protected synchronized void handleView(View v) {
        boolean left_mbrs = this.change_key_on_leave && this.view != null && !v.containsMembers(this.view.getMembersRaw());
        super.handleView(v);
        Address tmpKeyServer = v.getCoord();
        if (tmpKeyServer.equals(this.local_addr)) {
            if (!this.is_key_server || left_mbrs) {
                this.becomeKeyServer(tmpKeyServer, left_mbrs);
            }
        } else {
            this.handleNewKeyServer(tmpKeyServer, v instanceof MergeView, left_mbrs);
        }
    }

    protected void becomeKeyServer(Address tmpKeyServer, boolean left_mbrs) {
        if (this.log.isDebugEnabled()) {
            if (!this.is_key_server) {
                this.log.debug(String.format("%s: I'm the new key server", this.local_addr));
            } else if (left_mbrs) {
                this.log.debug(String.format("%s: creating new secret key because members left", this.local_addr));
            }
        }
        this.key_server_addr = tmpKeyServer;
        this.is_key_server = true;
        try {
            this.secret_key = this.createSecretKey();
            this.initSymCiphers(this.sym_algorithm, this.secret_key);
            this.drainUpQueue();
        }
        catch (Exception ex) {
            this.log.error(this.local_addr + ": failed creating secret key and initializing ciphers", ex);
        }
    }

    protected void handleNewKeyServer(Address newKeyServer, boolean merge_view, boolean left_mbrs) {
        if (this.keyServerChanged(newKeyServer) || merge_view || left_mbrs) {
            this.secret_key = null;
            this.sym_version = null;
            this.queue_up_msgs = true;
            this.key_server_addr = newKeyServer;
            this.is_key_server = false;
            this.log.debug(String.format("%s: sending request for secret key to the new keyserver %s", this.local_addr, this.key_server_addr));
            this.sendKeyRequest(this.key_server_addr);
        }
    }

    protected boolean keyServerChanged(Address newKeyServer) {
        return !ASYM_ENCRYPT.equals(this.key_server_addr, newKeyServer);
    }

    protected void setKeys(SecretKey key, byte[] version) throws Exception {
        Cipher decoding_cipher;
        if (Arrays.equals(this.sym_version, version)) {
            return;
        }
        Cipher cipher = decoding_cipher = this.secret_key != null ? (Cipher)this.decoding_ciphers.take() : null;
        if (decoding_cipher != null) {
            this.key_map.put(new AsciiString(version), decoding_cipher);
        }
        this.secret_key = key;
        this.initSymCiphers(key.getAlgorithm(), key);
        this.sym_version = version;
        this.drainUpQueue();
    }

    protected void sendSecretKey(SecretKey secret_key, PublicKey public_key, Address source) throws Exception {
        byte[] encryptedKey = this.encryptSecretKey(secret_key, public_key);
        Message newMsg = new Message(source, this.local_addr, encryptedKey).putHeader(this.id, new EncryptHeader(4, this.symVersion()));
        this.log.debug(String.format("%s: sending secret key to %s", this.local_addr, source));
        this.down_prot.down(new Event(1, newMsg));
    }

    protected byte[] encryptSecretKey(SecretKey secret_key, PublicKey public_key) throws Exception {
        Cipher tmp = this.provider != null && !this.provider.trim().isEmpty() ? Cipher.getInstance(this.asym_algorithm, this.provider) : Cipher.getInstance(this.asym_algorithm);
        tmp.init(1, public_key);
        return tmp.doFinal(secret_key.getEncoded());
    }

    protected void sendKeyRequest(Address key_server) {
        Message newMsg = new Message(key_server, this.local_addr, this.key_pair.getPublic().getEncoded()).putHeader(this.id, new EncryptHeader(2, this.sym_version));
        this.down_prot.down(new Event(1, newMsg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SecretKeySpec decodeKey(byte[] encodedKey) throws Exception {
        byte[] keyBytes;
        ASYM_ENCRYPT aSYM_ENCRYPT = this;
        synchronized (aSYM_ENCRYPT) {
            keyBytes = this.asym_cipher.doFinal(encodedKey);
        }
        try {
            SecretKeySpec keySpec = new SecretKeySpec(keyBytes, ASYM_ENCRYPT.getAlgorithm(this.sym_algorithm));
            Cipher temp = this.provider != null && !this.provider.trim().isEmpty() ? Cipher.getInstance(this.sym_algorithm, this.provider) : Cipher.getInstance(this.sym_algorithm);
            temp.init(3, keySpec);
            return keySpec;
        }
        catch (Exception e) {
            this.log.error(Util.getMessage("FailedDecodingKey"), e);
            return null;
        }
    }

    protected void drainUpQueue() {
        Message queued_msg;
        this.queue_up_msgs = false;
        while ((queued_msg = (Message)this.up_queue.poll()) != null) {
            try {
                Message decrypted_msg = this.decryptMessage(null, queued_msg.copy());
                if (decrypted_msg == null) continue;
                this.up_prot.up(new Event(1, decrypted_msg));
            }
            catch (Exception ex) {
                this.log.error(String.format("failed decrypting message from %s: %s", queued_msg.src(), ex));
            }
        }
    }

    @Override
    protected void handleUnknownVersion() {
        if (!this.is_key_server) {
            this.sendKeyRequest(this.key_server_addr);
        }
    }

    protected PublicKey generatePubKey(byte[] encodedKey) {
        PublicKey pubKey = null;
        try {
            KeyFactory KeyFac = KeyFactory.getInstance(ASYM_ENCRYPT.getAlgorithm(this.asym_algorithm));
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(encodedKey);
            pubKey = KeyFac.generatePublic(x509KeySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pubKey;
    }

    protected static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }
}

