/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.explorer.model;

import java.util.ArrayList;
import java.util.List;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.workbench.common.screens.explorer.model.FolderItemOperation;
import org.kie.workbench.common.screens.explorer.model.FolderItemType;
import org.uberfire.commons.validation.PortablePreconditions;

@Portable
public class FolderItem {
    private Object item;
    private String itemName;
    private FolderItemType type;
    private String lockedBy;
    private boolean lockedItems;
    private List<String> tags = new ArrayList<String>();
    private List<FolderItemOperation> restrictedOperations = new ArrayList<FolderItemOperation>();

    public FolderItem(@MapsTo(value="item") Object item, @MapsTo(value="itemName") String itemName, @MapsTo(value="type") FolderItemType type, @MapsTo(value="lockedItems") boolean lockedItems, @MapsTo(value="lockedBy") String lockedBy, @MapsTo(value="tags") List<String> tags, @MapsTo(value="restrictedOperations") List<FolderItemOperation> restrictedOperations) {
        this(item, itemName, type);
        this.lockedItems = lockedItems;
        this.lockedBy = lockedBy;
        this.tags = tags;
        this.restrictedOperations = restrictedOperations;
    }

    public FolderItem(Object item, String itemName, FolderItemType type) {
        this.item = PortablePreconditions.checkNotNull((String)"item", (Object)item);
        this.itemName = (String)PortablePreconditions.checkNotNull((String)"itemName", (Object)itemName);
        this.type = (FolderItemType)((Object)PortablePreconditions.checkNotNull((String)"type", (Object)((Object)type)));
    }

    public Object getItem() {
        return this.item;
    }

    public String getFileName() {
        return this.itemName;
    }

    public FolderItemType getType() {
        return this.type;
    }

    public boolean hasLockedItems() {
        return this.lockedItems;
    }

    public String getLockedBy() {
        return this.lockedBy;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public boolean canDoOperation(FolderItemOperation operation) {
        return !this.restrictedOperations.contains((Object)operation);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
        result = 31 * result + (this.itemName == null ? 0 : this.itemName.hashCode());
        result = 31 * result + (this.lockedBy == null ? 0 : this.lockedBy.hashCode());
        result = 31 * result + (this.lockedItems ? 1231 : 1237);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FolderItem other = (FolderItem)obj;
        if (this.item == null ? other.item != null : !this.item.equals(other.item)) {
            return false;
        }
        if (this.itemName == null ? other.itemName != null : !this.itemName.equals(other.itemName)) {
            return false;
        }
        if (this.lockedBy == null ? other.lockedBy != null : !this.lockedBy.equals(other.lockedBy)) {
            return false;
        }
        if (this.lockedItems != other.lockedItems) {
            return false;
        }
        return this.type == other.type;
    }
}

