/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.decorator.Decorator;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessSessionBean;
import javax.enterprise.util.AnnotationLiteral;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.cdi.JaxrsAnnotatedType;
import org.jboss.resteasy.cdi.JaxrsInjectionTarget;
import org.jboss.resteasy.cdi.Utils;
import org.jboss.resteasy.cdi.i18n.LogMessages;
import org.jboss.resteasy.cdi.i18n.Messages;
import org.jboss.resteasy.util.GetRestful;

public class ResteasyCdiExtension
implements Extension {
    private BeanManager beanManager;
    private static final String JAVAX_EJB_STATELESS = "javax.ejb.Stateless";
    private static final String JAVAX_EJB_SINGLETON = "javax.ejb.Singleton";
    public static final Annotation requestScopedLiteral = new AnnotationLiteral<RequestScoped>(){
        private static final long serialVersionUID = 3381824686081435817L;
    };
    public static final Annotation applicationScopedLiteral = new AnnotationLiteral<ApplicationScoped>(){
        private static final long serialVersionUID = -8211157243671012820L;
    };
    private Map<Class<?>, Type> sessionBeanInterface = new HashMap();

    public void observeBeforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    public <T> void observeResources(@Observes ProcessAnnotatedType<T> event, BeanManager beanManager) {
        AnnotatedType type;
        if (this.beanManager == null) {
            this.beanManager = beanManager;
        }
        if (!(type = event.getAnnotatedType()).getJavaClass().isInterface()) {
            for (Annotation annotation : type.getAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (!annotationType.getName().equals(JAVAX_EJB_STATELESS) && !annotationType.getName().equals(JAVAX_EJB_SINGLETON)) continue;
                LogMessages.LOGGER.debug(Messages.MESSAGES.beanIsSLSBOrSingleton(type.getJavaClass()));
                return;
            }
            if (type.isAnnotationPresent(Provider.class)) {
                LogMessages.LOGGER.debug(Messages.MESSAGES.discoveredCDIBeanJaxRsProvider(type.getJavaClass().getCanonicalName()));
                event.setAnnotatedType(this.wrapAnnotatedType(type, applicationScopedLiteral));
            } else if (GetRestful.isRootResource((Class)type.getJavaClass()) && !type.isAnnotationPresent(Decorator.class)) {
                LogMessages.LOGGER.debug(Messages.MESSAGES.discoveredCDIBeanJaxRsResource(type.getJavaClass().getCanonicalName()));
                event.setAnnotatedType(this.wrapAnnotatedType(type, requestScopedLiteral));
            } else if (Application.class.isAssignableFrom(type.getJavaClass())) {
                LogMessages.LOGGER.debug(Messages.MESSAGES.discoveredCDIBeanApplication(type.getJavaClass().getCanonicalName()));
                event.setAnnotatedType(this.wrapAnnotatedType(type, applicationScopedLiteral));
            }
        }
    }

    protected <T> AnnotatedType<T> wrapAnnotatedType(AnnotatedType<T> type, Annotation scope) {
        if (Utils.isScopeDefined(type.getJavaClass(), this.beanManager)) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.beanHasScopeDefined(type.getJavaClass()));
            return type;
        }
        LogMessages.LOGGER.debug(Messages.MESSAGES.beanDoesNotHaveScopeDefined(type.getJavaClass(), scope));
        return new JaxrsAnnotatedType<T>(type, scope);
    }

    public <T> void observeInjectionTarget(@Observes ProcessInjectionTarget<T> event) {
        if (event.getAnnotatedType() == null) {
            LogMessages.LOGGER.warn(Messages.MESSAGES.annotatedTypeNull());
            return;
        }
        if (Utils.isJaxrsComponent(event.getAnnotatedType().getJavaClass())) {
            event.setInjectionTarget(this.wrapInjectionTarget(event));
        }
    }

    protected <T> InjectionTarget<T> wrapInjectionTarget(ProcessInjectionTarget<T> event) {
        return new JaxrsInjectionTarget(event.getInjectionTarget(), event.getAnnotatedType().getJavaClass());
    }

    public <T> void observeSessionBeans(@Observes ProcessSessionBean<T> event) {
        Bean sessionBean = event.getBean();
        if (Utils.isJaxrsComponent(sessionBean.getBeanClass())) {
            this.addSessionBeanInterface(sessionBean);
        }
    }

    private void addSessionBeanInterface(Bean<?> bean) {
        for (Type type : bean.getTypes()) {
            Class clazz;
            if (!(type instanceof Class) || !((Class)type).isInterface() || !Utils.isJaxrsAnnotatedClass(clazz = (Class)type)) continue;
            this.sessionBeanInterface.put(bean.getBeanClass(), type);
            LogMessages.LOGGER.debug(Messages.MESSAGES.typeWillBeUsedForLookup(type, bean.getBeanClass()));
            return;
        }
        LogMessages.LOGGER.debug(Messages.MESSAGES.noLookupInterface(bean.getBeanClass()));
    }

    public Map<Class<?>, Type> getSessionBeanInterface() {
        return this.sessionBeanInterface;
    }
}

