/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.validation.asset;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.backend.validation.GenericValidator;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.kie.workbench.common.services.backend.validation.asset.ValidatorBuildService;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class DefaultGenericKieValidator
implements GenericValidator {
    private ValidatorBuildService validatorBuildService;

    public DefaultGenericKieValidator() {
    }

    @Inject
    public DefaultGenericKieValidator(ValidatorBuildService validatorBuildService) {
        this.validatorBuildService = validatorBuildService;
    }

    public List<ValidationMessage> validate(Path path, String content) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        for (ValidationMessage message : this.validatorBuildService.validate(path, content)) {
            if (!this.isValidPath(path, message)) continue;
            messages.add(message);
        }
        return messages;
    }

    public List<ValidationMessage> validate(Path path) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        for (ValidationMessage message : this.validatorBuildService.validate(path)) {
            if (!this.isValidPath(path, message)) continue;
            messages.add(message);
        }
        return messages;
    }

    protected boolean isValidPath(Path path, ValidationMessage message) {
        String destinationPathURI = this.removeFileExtension(path.toURI());
        String messageURI = message.getPath() != null ? this.removeFileExtension(message.getPath().toURI()) : "";
        return messageURI.isEmpty() || destinationPathURI.endsWith(messageURI);
    }

    private String removeFileExtension(String pathURI) {
        if (pathURI != null && pathURI.contains(".")) {
            return pathURI.substring(0, pathURI.lastIndexOf("."));
        }
        return pathURI;
    }
}

