/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.explorer.backend.server;

import com.thoughtworks.xstream.XStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.events.DeleteProjectEvent;
import org.guvnor.common.services.project.events.RenameProjectEvent;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.workbench.common.screens.explorer.backend.server.ExplorerServiceHelper;
import org.kie.workbench.common.screens.explorer.backend.server.ProjectExplorerContentResolver;
import org.kie.workbench.common.screens.explorer.backend.server.UserExplorerData;
import org.kie.workbench.common.screens.explorer.backend.server.UserExplorerLastData;
import org.kie.workbench.common.screens.explorer.model.FolderItem;
import org.kie.workbench.common.screens.explorer.model.FolderItemType;
import org.kie.workbench.common.screens.explorer.model.FolderListing;
import org.kie.workbench.common.screens.explorer.model.ProjectExplorerContent;
import org.kie.workbench.common.screens.explorer.model.URIStructureExplorerModel;
import org.kie.workbench.common.screens.explorer.service.ActiveOptions;
import org.kie.workbench.common.screens.explorer.service.ExplorerService;
import org.kie.workbench.common.screens.explorer.service.Option;
import org.kie.workbench.common.screens.explorer.service.ProjectExplorerContentQuery;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.UserServicesBackendImpl;
import org.uberfire.backend.server.UserServicesImpl;
import org.uberfire.backend.server.VFSLockServiceImpl;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.commons.async.DescriptiveRunnable;
import org.uberfire.commons.async.SimpleAsyncExecutorService;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.editor.commons.backend.service.helper.CopyHelper;
import org.uberfire.ext.editor.commons.backend.service.helper.RenameHelper;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;

@Service
@Dependent
public class ExplorerServiceImpl
implements ExplorerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExplorerServiceImpl.class);
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    @Named(value="configIO")
    private IOService ioServiceConfig;
    @Inject
    @Named(value="systemFS")
    private FileSystem fileSystem;
    @Inject
    private KieProjectService projectService;
    @Inject
    private ExplorerServiceHelper helper;
    @Inject
    private OrganizationalUnitService organizationalUnitService;
    @Inject
    private User identity;
    @Inject
    private SessionInfo sessionInfo;
    @Inject
    private UserServicesImpl userServices;
    @Inject
    private UserServicesBackendImpl userServicesBackend;
    @Inject
    private Instance<RenameHelper> renameHelpers;
    @Inject
    private Instance<CopyHelper> copyHelpers;
    @Inject
    private ProjectExplorerContentResolver projectExplorerContentResolver;
    @Inject
    private RepositoryService repositoryService;
    @Inject
    private VFSLockServiceImpl lockService;
    @Inject
    private DeleteService deleteService;
    @Inject
    private RenameService renameService;
    @Inject
    private CopyService copyService;
    @Inject
    private AuthorizationManager authorizationManager;
    private XStream xs = new XStream();

    public ExplorerServiceImpl() {
    }

    public ExplorerServiceImpl(IOService ioService, KieProjectService projectService, OrganizationalUnitService organizationalUnitService, User identity) {
        this.ioService = ioService;
        this.projectService = projectService;
        this.organizationalUnitService = organizationalUnitService;
        this.identity = identity;
    }

    public ProjectExplorerContent getContent(String _path, ActiveOptions activeOptions) {
        PortablePreconditions.checkNotEmpty((String)"path", (String)_path);
        org.uberfire.backend.vfs.Path path = Paths.convert((Path)this.ioService.get(URI.create(_path.trim())));
        Project project = this.projectService.resolveProject(path);
        org.uberfire.backend.vfs.Path convertedPath = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)path).getRoot());
        Repository repo = this.repositoryService.getRepository(convertedPath);
        String branch = this.getBranchName(repo, convertedPath);
        OrganizationalUnit ou = null;
        for (OrganizationalUnit organizationalUnit : this.organizationalUnitService.getOrganizationalUnits()) {
            if (!organizationalUnit.getRepositories().contains(repo)) continue;
            ou = organizationalUnit;
            break;
        }
        return this.getContent(new ProjectExplorerContentQuery(ou, repo, branch, project, activeOptions));
    }

    private String getBranchName(Repository repository, org.uberfire.backend.vfs.Path convertedPath) {
        for (String branchName : repository.getBranches()) {
            if (!repository.getBranchRoot(branchName).equals(convertedPath)) continue;
            return branchName;
        }
        return null;
    }

    public ProjectExplorerContent getContent(ProjectExplorerContentQuery query) {
        return this.projectExplorerContentResolver.resolve(query);
    }

    public URIStructureExplorerModel getURIStructureExplorerModel(org.uberfire.backend.vfs.Path originalURI) {
        KieProject project = this.getURIProject(originalURI);
        Repository repository = this.getURIRepository(originalURI);
        OrganizationalUnit ou = this.getURIOrganizationalUnits(repository);
        return new URIStructureExplorerModel(ou, repository, (Project)project);
    }

    private KieProject getURIProject(org.uberfire.backend.vfs.Path originalURI) {
        return (KieProject)this.projectService.resolveProject(originalURI);
    }

    private Repository getURIRepository(org.uberfire.backend.vfs.Path originalURI) {
        Path ufPath = Paths.convert((org.uberfire.backend.vfs.Path)originalURI);
        return this.repositoryService.getRepository(Paths.convert((Path)ufPath.getRoot()));
    }

    private OrganizationalUnit getURIOrganizationalUnits(Repository repository) {
        for (OrganizationalUnit organizationalUnit : this.getOrganizationalUnits()) {
            if (!organizationalUnit.getRepositories().contains(repository)) continue;
            return organizationalUnit;
        }
        throw new OrganizationalUnitNotFoundForURI();
    }

    private Set<OrganizationalUnit> getOrganizationalUnits() {
        Collection organizationalUnits = this.organizationalUnitService.getOrganizationalUnits();
        HashSet<OrganizationalUnit> authorizedOrganizationalUnits = new HashSet<OrganizationalUnit>();
        for (OrganizationalUnit organizationalUnit : organizationalUnits) {
            if (!this.authorizationManager.authorize((Resource)organizationalUnit, this.identity)) continue;
            authorizedOrganizationalUnits.add(organizationalUnit);
        }
        return authorizedOrganizationalUnits;
    }

    public FolderListing getFolderListing(final OrganizationalUnit organizationalUnit, final Repository repository, final String branch, final Project project, final FolderItem item, final ActiveOptions options) {
        FolderListing result = this.helper.getFolderListing(item, options);
        if (result != null) {
            final Path userNavPath = this.userServices.buildPath("explorer", "user.nav");
            final Path lastUserNavPath = this.userServices.buildPath("explorer", "last.user.nav");
            SimpleAsyncExecutorService.getDefaultInstance().execute((Runnable)new DescriptiveRunnable(){

                public String getDescription() {
                    return "Serialize Navigation State";
                }

                public void run() {
                    try {
                        Package pkg = null;
                        if (item.getItem() instanceof Package) {
                            pkg = (Package)item.getItem();
                        }
                        ExplorerServiceImpl.this.helper.store(userNavPath, lastUserNavPath, organizationalUnit, repository, branch, project, pkg, item, options);
                    }
                    catch (Exception e) {
                        LOGGER.error("Can't serialize user's state navigation", (Throwable)e);
                    }
                }
            });
        }
        return result;
    }

    private List<org.uberfire.backend.vfs.Path> resolvePath(final FolderItem item) {
        if (item == null) {
            return Collections.emptyList();
        }
        if (item.getItem() instanceof Package) {
            final Package pkg = (Package)item.getItem();
            return new ArrayList<org.uberfire.backend.vfs.Path>(4){
                {
                    super(x0);
                    this.add(pkg.getPackageMainResourcesPath());
                    this.add(pkg.getPackageMainSrcPath());
                    this.add(pkg.getPackageTestResourcesPath());
                    this.add(pkg.getPackageTestSrcPath());
                }
            };
        }
        if (item.getItem() instanceof org.uberfire.backend.vfs.Path) {
            if (item.getType() == FolderItemType.FOLDER) {
                final Package pkg = this.projectService.resolvePackage((org.uberfire.backend.vfs.Path)item.getItem());
                if (pkg == null) {
                    return new ArrayList<org.uberfire.backend.vfs.Path>(1){
                        {
                            super(x0);
                            this.add((org.uberfire.backend.vfs.Path)item.getItem());
                        }
                    };
                }
                return new ArrayList<org.uberfire.backend.vfs.Path>(4){
                    {
                        super(x0);
                        this.add(pkg.getPackageMainResourcesPath());
                        this.add(pkg.getPackageMainSrcPath());
                        this.add(pkg.getPackageTestResourcesPath());
                        this.add(pkg.getPackageTestSrcPath());
                    }
                };
            }
            return new ArrayList<org.uberfire.backend.vfs.Path>(1){
                {
                    super(x0);
                    this.add((org.uberfire.backend.vfs.Path)item.getItem());
                }
            };
        }
        return Collections.emptyList();
    }

    public Package resolvePackage(FolderItem item) {
        if (item == null) {
            return null;
        }
        if (item.getItem() instanceof Package) {
            return (Package)item.getItem();
        }
        if (item.getItem() instanceof org.uberfire.backend.vfs.Path) {
            return this.projectService.resolvePackage((org.uberfire.backend.vfs.Path)item.getItem());
        }
        return null;
    }

    public Set<Option> getLastUserOptions() {
        return this.helper.getLastContent().getOptions();
    }

    public void deleteItem(FolderItem folderItem, String comment) {
        List<org.uberfire.backend.vfs.Path> paths = this.resolvePath(folderItem);
        this.deleteService.deleteIfExists(paths, comment);
    }

    public void renameItem(FolderItem folderItem, String newName, String comment) {
        List<org.uberfire.backend.vfs.Path> paths = this.resolvePath(folderItem);
        this.renameService.renameIfExists(paths, newName, comment);
    }

    public void copyItem(FolderItem folderItem, String newName, org.uberfire.backend.vfs.Path targetDirectory, String comment) {
        List<org.uberfire.backend.vfs.Path> paths = this.resolvePath(folderItem);
        if (paths != null && paths.size() == 1) {
            this.copyService.copy(paths.get(0), newName, targetDirectory, comment);
        } else {
            this.copyService.copyIfExists(paths, newName, comment);
        }
    }

    void onProjectRename(@Observes RenameProjectEvent event) {
        this.cleanup(event.getOldProject());
    }

    void onProjectDelete(@Observes DeleteProjectEvent event) {
        this.cleanup(event.getProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(Project project) {
        Collection lastNavs = this.userServicesBackend.getAllUsersData("explorer", "last.user.nav");
        Collection userNavs = this.userServicesBackend.getAllUsersData("explorer", "user.nav");
        try {
            this.ioServiceConfig.startBatch(this.fileSystem);
            for (Path path : userNavs) {
                UserExplorerData userContent = this.helper.loadUserContent(path);
                if (userContent == null || !userContent.deleteProject(project)) continue;
                this.ioServiceConfig.write(path, this.xs.toXML((Object)userContent), new OpenOption[0]);
            }
            for (Path lastNav : lastNavs) {
                UserExplorerLastData lastUserContent = this.helper.getLastContent(lastNav);
                if (lastUserContent == null || !lastUserContent.deleteProject(project)) continue;
                this.ioServiceConfig.write(lastNav, this.xs.toXML((Object)lastUserContent), new OpenOption[0]);
            }
        }
        finally {
            this.ioServiceConfig.endBatch();
        }
    }

    public class OrganizationalUnitNotFoundForURI
    extends RuntimeException {
    }
}

