/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.I0Itec.zkclient.DataUpdater;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.helix.AccessOption;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixManagerFactory;
import org.apache.helix.HelixProperty;
import org.apache.helix.InstanceType;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyPathConfig;
import org.apache.helix.PropertyType;
import org.apache.helix.ZNRecord;
import org.apache.helix.manager.zk.ZKHelixAdmin;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.builder.CustomModeISBuilder;
import org.apache.helix.store.HelixPropertyStore;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.helix.task.FixedTargetTaskRebalancer;
import org.apache.helix.task.GenericTaskRebalancer;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.JobDag;
import org.apache.helix.task.JobQueue;
import org.apache.helix.task.TargetState;
import org.apache.helix.task.TaskConfig;
import org.apache.helix.task.TaskPartitionState;
import org.apache.helix.task.TaskState;
import org.apache.helix.task.TaskUtil;
import org.apache.helix.task.Workflow;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.apache.log4j.Logger;

public class TaskDriver {
    private static final Logger LOG = Logger.getLogger(TaskDriver.class);
    private static final String ZK_ADDRESS = "zk";
    private static final String CLUSTER_NAME_OPTION = "cluster";
    private static final String RESOURCE_OPTION = "resource";
    private static final String WORKFLOW_FILE_OPTION = "file";
    private final HelixDataAccessor _accessor;
    private final ConfigAccessor _cfgAccessor;
    private final HelixPropertyStore<ZNRecord> _propertyStore;
    private final HelixAdmin _admin;
    private final String _clusterName;

    public TaskDriver(HelixManager manager) {
        this(manager.getClusterManagmentTool(), manager.getHelixDataAccessor(), manager.getConfigAccessor(), manager.getHelixPropertyStore(), manager.getClusterName());
    }

    public TaskDriver(ZkClient client, String clusterName) {
        this(client, new ZkBaseDataAccessor<ZNRecord>(client), clusterName);
    }

    public TaskDriver(ZkClient client, ZkBaseDataAccessor<ZNRecord> baseAccessor, String clusterName) {
        this(new ZKHelixAdmin(client), new ZKHelixDataAccessor(clusterName, baseAccessor), new ConfigAccessor(client), new ZkHelixPropertyStore<ZNRecord>(baseAccessor, PropertyPathConfig.getPath(PropertyType.PROPERTYSTORE, clusterName, new String[0]), null), clusterName);
    }

    public TaskDriver(HelixAdmin admin, HelixDataAccessor accessor, ConfigAccessor cfgAccessor, HelixPropertyStore<ZNRecord> propertyStore, String clusterName) {
        this._admin = admin;
        this._accessor = accessor;
        this._cfgAccessor = cfgAccessor;
        this._propertyStore = propertyStore;
        this._clusterName = clusterName;
    }

    public static void main(String[] args) throws Exception {
        String[] cmdArgs = Arrays.copyOfRange(args, 1, args.length);
        CommandLine cl = TaskDriver.parseOptions(cmdArgs, TaskDriver.constructOptions(), args[0]);
        String zkAddr = cl.getOptionValue(ZK_ADDRESS);
        String clusterName = cl.getOptionValue(CLUSTER_NAME_OPTION);
        String resource = cl.getOptionValue(RESOURCE_OPTION);
        if (zkAddr == null || clusterName == null || resource == null) {
            TaskDriver.printUsage(TaskDriver.constructOptions(), "[cmd]");
            throw new IllegalArgumentException("zk, cluster, and resource must all be non-null for all commands");
        }
        HelixManager helixMgr = HelixManagerFactory.getZKHelixManager(clusterName, "Admin", InstanceType.ADMINISTRATOR, zkAddr);
        helixMgr.connect();
        TaskDriver driver = new TaskDriver(helixMgr);
        try {
            DriverCommand cmd = DriverCommand.valueOf(args[0]);
            switch (cmd) {
                case start: {
                    if (cl.hasOption(WORKFLOW_FILE_OPTION)) {
                        driver.start(Workflow.parse(new File(cl.getOptionValue(WORKFLOW_FILE_OPTION))));
                        break;
                    }
                    throw new IllegalArgumentException("Workflow file is required to start flow.");
                }
                case stop: {
                    driver.setWorkflowTargetState(resource, TargetState.STOP);
                    break;
                }
                case resume: {
                    driver.setWorkflowTargetState(resource, TargetState.START);
                    break;
                }
                case delete: {
                    driver.setWorkflowTargetState(resource, TargetState.DELETE);
                    break;
                }
                case list: {
                    driver.list(resource);
                    break;
                }
                case flush: {
                    driver.flushQueue(resource);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown command " + args[0]);
                }
            }
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("Unknown driver command " + args[0]));
            throw e;
        }
        helixMgr.disconnect();
    }

    public void start(Workflow flow) throws Exception {
        LOG.info((Object)("Starting workflow " + flow.getName()));
        flow.validate();
        String flowName = flow.getName();
        this._admin.setConfig(TaskUtil.getResourceConfigScope(this._clusterName, flowName), flow.getWorkflowConfig().getResourceConfigMap());
        for (String job : flow.getJobConfigs().keySet()) {
            JobConfig.Builder builder = JobConfig.Builder.fromMap(flow.getJobConfigs().get(job));
            if (flow.getTaskConfigs() != null && flow.getTaskConfigs().containsKey(job)) {
                builder.addTaskConfigs(flow.getTaskConfigs().get(job));
            }
            this.scheduleJob(job, builder.build());
        }
    }

    public void createQueue(JobQueue queue) throws Exception {
        String queueName = queue.getName();
        HelixProperty property = new HelixProperty(queueName);
        property.getRecord().getSimpleFields().putAll(queue.getResourceConfigMap());
        boolean created = this._accessor.createProperty(this._accessor.keyBuilder().resourceConfig(queueName), property);
        if (!created) {
            throw new IllegalArgumentException("Queue " + queueName + " already exists!");
        }
    }

    public void flushQueue(String queueName) throws Exception {
        WorkflowConfig config = TaskUtil.getWorkflowCfg(this._cfgAccessor, this._accessor, this._clusterName, queueName);
        if (config == null) {
            throw new IllegalArgumentException("Queue does not exist!");
        }
        PropertyKey.Builder keyBuilder = this._accessor.keyBuilder();
        final HashSet toRemove = Sets.newHashSet(config.getJobDag().getAllNodes());
        for (String resourceName : toRemove) {
            this._accessor.removeProperty(keyBuilder.idealStates(resourceName));
            this._accessor.removeProperty(keyBuilder.resourceConfig(resourceName));
            String contextKey = Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)resourceName, new Object[0]);
            this._propertyStore.remove(contextKey, AccessOption.PERSISTENT);
        }
        String path = keyBuilder.resourceConfig(queueName).getPath();
        Object updater = new DataUpdater<ZNRecord>(){

            public ZNRecord update(ZNRecord currentData) {
                JobDag jobDag = JobDag.fromJson(currentData.getSimpleField("Dag"));
                for (String resourceName : toRemove) {
                    for (String child : jobDag.getDirectChildren(resourceName)) {
                        jobDag.getChildrenToParents().get(child).remove(resourceName);
                    }
                    for (String parent : jobDag.getDirectParents(resourceName)) {
                        jobDag.getParentsToChildren().get(parent).remove(resourceName);
                    }
                    jobDag.getChildrenToParents().remove(resourceName);
                    jobDag.getParentsToChildren().remove(resourceName);
                    jobDag.getAllNodes().remove(resourceName);
                }
                try {
                    currentData.setSimpleField("Dag", jobDag.toJson());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
                return currentData;
            }
        };
        this._accessor.getBaseDataAccessor().update(path, (DataUpdater<ZNRecord>)updater, AccessOption.PERSISTENT);
        path = Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)queueName, new Object[]{"Context"});
        updater = new DataUpdater<ZNRecord>(){

            public ZNRecord update(ZNRecord currentData) {
                Map<String, String> states = currentData.getMapField("JOB_STATES");
                if (states != null) {
                    states.keySet().removeAll(toRemove);
                }
                return currentData;
            }
        };
        this._propertyStore.update(path, (DataUpdater<ZNRecord>)updater, AccessOption.PERSISTENT);
    }

    public void deleteJob(final String queueName, final String jobName) {
        String workflowState;
        Object workflowConfig = this._accessor.getProperty(this._accessor.keyBuilder().resourceConfig(queueName));
        if (workflowConfig == null) {
            throw new IllegalArgumentException("Queue " + queueName + " does not yet exist!");
        }
        boolean isTerminable = ((HelixProperty)workflowConfig).getRecord().getBooleanField("Terminable", true);
        if (isTerminable) {
            throw new IllegalArgumentException(queueName + " is not a queue!");
        }
        WorkflowContext wCtx = TaskUtil.getWorkflowContext(this._propertyStore, queueName);
        String string = workflowState = wCtx != null ? wCtx.getWorkflowState().name() : TaskState.NOT_STARTED.name();
        if (workflowState.equals((Object)TaskState.IN_PROGRESS)) {
            throw new IllegalStateException("Queue " + queueName + " is still in progress!");
        }
        final String namespacedJobName = TaskUtil.getNamespacedJobName(queueName, jobName);
        Object updater = new DataUpdater<ZNRecord>(){

            public ZNRecord update(ZNRecord currentData) {
                JobDag jobDag = JobDag.fromJson(currentData.getSimpleField("Dag"));
                Set<String> allNodes = jobDag.getAllNodes();
                if (!allNodes.contains(namespacedJobName)) {
                    throw new IllegalStateException("Could not delete job from queue " + queueName + ", job " + jobName + " not exists");
                }
                String parent = null;
                String child = null;
                for (String node : allNodes) {
                    if (node.equals(namespacedJobName)) continue;
                    if (jobDag.getDirectChildren(node).contains(namespacedJobName)) {
                        parent = node;
                        jobDag.removeParentToChild(parent, namespacedJobName);
                        continue;
                    }
                    if (!jobDag.getDirectParents(node).contains(namespacedJobName)) continue;
                    child = node;
                    jobDag.removeParentToChild(namespacedJobName, child);
                }
                if (parent != null && child != null) {
                    jobDag.addParentToChild(parent, child);
                }
                jobDag.removeNode(namespacedJobName);
                try {
                    currentData.setSimpleField("Dag", jobDag.toJson());
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not remove job " + jobName + " from queue " + queueName, e);
                }
                return currentData;
            }
        };
        String path = this._accessor.keyBuilder().resourceConfig(queueName).getPath();
        boolean status = this._accessor.getBaseDataAccessor().update(path, (DataUpdater<ZNRecord>)updater, AccessOption.PERSISTENT);
        if (!status) {
            throw new IllegalArgumentException("Could not enqueue job");
        }
        this._admin.dropResource(this._clusterName, namespacedJobName);
        String queuePropertyPath = Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)queueName, new Object[]{"Context"});
        updater = new DataUpdater<ZNRecord>(){

            public ZNRecord update(ZNRecord currentData) {
                Map<String, String> states;
                if (currentData != null && (states = currentData.getMapField("JOB_STATES")) != null && states.containsKey(namespacedJobName)) {
                    states.keySet().remove(namespacedJobName);
                }
                return currentData;
            }
        };
        this._propertyStore.update(queuePropertyPath, (DataUpdater<ZNRecord>)updater, AccessOption.PERSISTENT);
        String jobPropertyPath = Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)namespacedJobName, new Object[0]);
        this._propertyStore.remove(jobPropertyPath, AccessOption.PERSISTENT);
    }

    public void enqueueJob(final String queueName, final String jobName, JobConfig.Builder jobBuilder) throws Exception {
        Object workflowConfig = this._accessor.getProperty(this._accessor.keyBuilder().resourceConfig(queueName));
        if (workflowConfig == null) {
            throw new IllegalArgumentException("Queue " + queueName + " does not yet exist!");
        }
        boolean isTerminable = ((HelixProperty)workflowConfig).getRecord().getBooleanField("Terminable", true);
        if (isTerminable) {
            throw new IllegalArgumentException(queueName + " is not a queue!");
        }
        final int capacity = ((HelixProperty)workflowConfig).getRecord().getIntField("CAPACITY", Integer.MAX_VALUE);
        JobConfig jobConfig = jobBuilder.setWorkflow(queueName).build();
        final String namespacedJobName = TaskUtil.getNamespacedJobName(queueName, jobName);
        DataUpdater<ZNRecord> updater = new DataUpdater<ZNRecord>(){

            public ZNRecord update(ZNRecord currentData) {
                JobDag jobDag = JobDag.fromJson(currentData.getSimpleField("Dag"));
                Set<String> allNodes = jobDag.getAllNodes();
                if (allNodes.size() >= capacity) {
                    throw new IllegalStateException("Queue " + queueName + " is at capacity, will not add " + jobName);
                }
                if (allNodes.contains(namespacedJobName)) {
                    throw new IllegalStateException("Could not add to queue " + queueName + ", job " + jobName + " already exists");
                }
                jobDag.addNode(namespacedJobName);
                String candidate = null;
                for (String node : allNodes) {
                    if (node.equals(namespacedJobName) || !jobDag.getDirectChildren(node).isEmpty()) continue;
                    candidate = node;
                    break;
                }
                if (candidate != null) {
                    jobDag.addParentToChild(candidate, namespacedJobName);
                }
                try {
                    currentData.setSimpleField("Dag", jobDag.toJson());
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not add job " + jobName + " to queue " + queueName, e);
                }
                return currentData;
            }
        };
        String path = this._accessor.keyBuilder().resourceConfig(queueName).getPath();
        boolean status = this._accessor.getBaseDataAccessor().update(path, updater, AccessOption.PERSISTENT);
        if (!status) {
            throw new IllegalArgumentException("Could not enqueue job");
        }
        this.scheduleJob(namespacedJobName, jobConfig);
    }

    private void scheduleJob(String jobResource, JobConfig jobConfig) throws Exception {
        int numIndependentTasks = jobConfig.getTaskConfigMap().size();
        int numPartitions = numIndependentTasks > 0 ? numIndependentTasks : this._admin.getResourceIdealState(this._clusterName, jobConfig.getTargetResource()).getPartitionSet().size();
        this._admin.addResource(this._clusterName, jobResource, numPartitions, "Task");
        PropertyKey.Builder keyBuilder = this._accessor.keyBuilder();
        HelixProperty resourceConfig = new HelixProperty(jobResource);
        resourceConfig.getRecord().getSimpleFields().putAll(jobConfig.getResourceConfigMap());
        Map<String, TaskConfig> taskConfigMap = jobConfig.getTaskConfigMap();
        if (taskConfigMap != null) {
            for (TaskConfig taskConfig : taskConfigMap.values()) {
                resourceConfig.getRecord().setMapField(taskConfig.getId(), taskConfig.getConfigMap());
            }
        }
        this._accessor.setProperty(keyBuilder.resourceConfig(jobResource), resourceConfig);
        CustomModeISBuilder builder = new CustomModeISBuilder(jobResource);
        builder.setRebalancerMode(IdealState.RebalanceMode.TASK);
        builder.setNumReplica(1);
        builder.setNumPartitions(numPartitions);
        builder.setStateModel("Task");
        IdealState is = builder.build();
        for (int i = 0; i < numPartitions; ++i) {
            is.getRecord().setListField(jobResource + "_" + i, new ArrayList<String>());
            is.getRecord().setMapField(jobResource + "_" + i, new HashMap<String, String>());
        }
        if (taskConfigMap != null && !taskConfigMap.isEmpty()) {
            is.setRebalancerClassName(GenericTaskRebalancer.class.getName());
        } else {
            is.setRebalancerClassName(FixedTargetTaskRebalancer.class.getName());
        }
        this._admin.setResourceIdealState(this._clusterName, jobResource, is);
    }

    public void resume(String workflow) {
        this.setWorkflowTargetState(workflow, TargetState.START);
    }

    public void stop(String workflow) {
        this.setWorkflowTargetState(workflow, TargetState.STOP);
    }

    public void delete(String workflow) {
        this.setWorkflowTargetState(workflow, TargetState.DELETE);
    }

    private void setWorkflowTargetState(String workflowName, TargetState state) {
        this.setSingleWorkflowTargetState(workflowName, state);
        List<String> resources = this._accessor.getChildNames(this._accessor.keyBuilder().resourceConfigs());
        String prefix = workflowName + "_" + "SCHEDULED";
        for (String resource : resources) {
            if (!resource.startsWith(prefix)) continue;
            this.setSingleWorkflowTargetState(resource, state);
        }
    }

    private void setSingleWorkflowTargetState(String workflowName, final TargetState state) {
        DataUpdater<ZNRecord> updater = new DataUpdater<ZNRecord>(){

            public ZNRecord update(ZNRecord currentData) {
                String finishTime = currentData.getSimpleField("FINISH_TIME");
                if (finishTime == null || finishTime.equals(-1)) {
                    currentData.setSimpleField("TargetState", state.name());
                }
                return currentData;
            }
        };
        ArrayList updaters = Lists.newArrayList();
        updaters.add(updater);
        ArrayList paths = Lists.newArrayList();
        paths.add(this._accessor.keyBuilder().resourceConfig(workflowName).getPath());
        this._accessor.updateChildren(paths, updaters, AccessOption.PERSISTENT);
        this.invokeRebalance();
    }

    public void list(String resource) {
        WorkflowConfig wCfg = TaskUtil.getWorkflowCfg(this._cfgAccessor, this._accessor, this._clusterName, resource);
        if (wCfg == null) {
            LOG.error((Object)("Workflow " + resource + " does not exist!"));
            return;
        }
        WorkflowContext wCtx = TaskUtil.getWorkflowContext(this._propertyStore, resource);
        LOG.info((Object)("Workflow " + resource + " consists of the following tasks: " + wCfg.getJobDag().getAllNodes()));
        String workflowState = wCtx != null ? wCtx.getWorkflowState().name() : TaskState.NOT_STARTED.name();
        LOG.info((Object)("Current state of workflow is " + workflowState));
        LOG.info((Object)"Job states are: ");
        LOG.info((Object)"-------");
        for (String job : wCfg.getJobDag().getAllNodes()) {
            TaskState jobState = wCtx != null ? wCtx.getJobState(job) : TaskState.NOT_STARTED;
            LOG.info((Object)("Job " + job + " is " + (Object)((Object)jobState)));
            JobConfig jCfg = TaskUtil.getJobCfg(this._accessor, job);
            JobContext jCtx = TaskUtil.getJobContext(this._propertyStore, job);
            if (jCfg == null || jCtx == null) {
                LOG.info((Object)"-------");
                continue;
            }
            ArrayList partitions = Lists.newArrayList(jCtx.getPartitionSet());
            Collections.sort(partitions);
            for (Integer partition : partitions) {
                TaskPartitionState state;
                String taskId = jCtx.getTaskIdForPartition(partition);
                taskId = taskId != null ? taskId : jCtx.getTargetForPartition(partition);
                LOG.info((Object)("Task: " + taskId));
                TaskConfig taskConfig = jCfg.getTaskConfig(taskId);
                if (taskConfig != null) {
                    LOG.info((Object)("Configuration: " + taskConfig.getConfigMap()));
                }
                state = (state = jCtx.getPartitionState(partition)) != null ? state : TaskPartitionState.INIT;
                LOG.info((Object)("State: " + (Object)((Object)state)));
                String assignedParticipant = jCtx.getAssignedParticipant(partition);
                if (assignedParticipant != null) {
                    LOG.info((Object)("Assigned participant: " + assignedParticipant));
                }
                LOG.info((Object)"-------");
            }
            LOG.info((Object)"-------");
        }
    }

    public void invokeRebalance() {
        for (String resource : this._admin.getResourcesInCluster(this._clusterName)) {
            IdealState is = this._admin.getResourceIdealState(this._clusterName, resource);
            if (!is.getStateModelDefRef().equals("Task")) continue;
            this._accessor.updateProperty(this._accessor.keyBuilder().idealStates(resource), is);
            break;
        }
    }

    private static Options constructOptions() {
        Options options = new Options();
        options.addOptionGroup(TaskDriver.contructGenericRequiredOptionGroup());
        options.addOptionGroup(TaskDriver.constructStartOptionGroup());
        return options;
    }

    private static OptionGroup contructGenericRequiredOptionGroup() {
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt((String)ZK_ADDRESS);
        OptionBuilder.withDescription((String)"ZK address managing cluster");
        Option zkAddressOption = OptionBuilder.create();
        zkAddressOption.setArgs(1);
        zkAddressOption.setArgName("zkAddress");
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt((String)CLUSTER_NAME_OPTION);
        OptionBuilder.withDescription((String)"Cluster name");
        Option clusterNameOption = OptionBuilder.create();
        clusterNameOption.setArgs(1);
        clusterNameOption.setArgName("clusterName");
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt((String)RESOURCE_OPTION);
        OptionBuilder.withDescription((String)"Workflow or job name");
        Option taskResourceOption = OptionBuilder.create();
        taskResourceOption.setArgs(1);
        taskResourceOption.setArgName("resourceName");
        OptionGroup group = new OptionGroup();
        group.addOption(zkAddressOption);
        group.addOption(clusterNameOption);
        group.addOption(taskResourceOption);
        return group;
    }

    private static OptionGroup constructStartOptionGroup() {
        OptionBuilder.withLongOpt((String)WORKFLOW_FILE_OPTION);
        OptionBuilder.withDescription((String)"Local file describing workflow");
        Option workflowFileOption = OptionBuilder.create();
        workflowFileOption.setArgs(1);
        workflowFileOption.setArgName("workflowFile");
        OptionGroup group = new OptionGroup();
        group.addOption(workflowFileOption);
        return group;
    }

    private static CommandLine parseOptions(String[] args, Options options, String cmdStr) {
        GnuParser cliParser = new GnuParser();
        CommandLine cmd = null;
        try {
            cmd = cliParser.parse(options, args);
        }
        catch (ParseException pe) {
            LOG.error((Object)("CommandLineClient: failed to parse command-line options: " + pe.toString()));
            TaskDriver.printUsage(options, cmdStr);
            System.exit(1);
        }
        boolean ret = TaskDriver.checkOptionArgsNumber(cmd.getOptions());
        if (!ret) {
            TaskDriver.printUsage(options, cmdStr);
            System.exit(1);
        }
        return cmd;
    }

    private static boolean checkOptionArgsNumber(Option[] options) {
        for (Option option : options) {
            int argNb = option.getArgs();
            Object[] args = option.getValues();
            if (argNb == 0) {
                if (args == null || args.length <= 0) continue;
                System.err.println(option.getArgName() + " shall have " + argNb + " arguments (was " + Arrays.toString(args) + ")");
                return false;
            }
            if (args != null && args.length == argNb) continue;
            System.err.println(option.getArgName() + " shall have " + argNb + " arguments (was " + Arrays.toString(args) + ")");
            return false;
        }
        return true;
    }

    private static void printUsage(Options cliOptions, String cmd) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setWidth(1000);
        helpFormatter.printHelp("java " + TaskDriver.class.getName() + " " + cmd, cliOptions);
    }

    public static enum DriverCommand {
        start,
        stop,
        delete,
        resume,
        list,
        flush;

    }
}

