/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.metadata.cache;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.inject.Stereotype;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotated;
import org.jboss.weld.logging.MetadataLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.metadata.cache.StereotypeModel;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.util.collections.ArraySet;
import org.jboss.weld.util.reflection.Reflections;

public class MergedStereotypes<T, E> {
    private final ArraySet<Annotation> possibleScopeTypes = new ArraySet();
    private boolean beanNameDefaulted;
    private boolean alternative;
    private Set<Class<? extends Annotation>> stereotypes = new ArraySet<Class<? extends Annotation>>();
    private final BeanManagerImpl manager;

    public static <T, E> MergedStereotypes<T, E> of(EnhancedAnnotated<T, E> annotated, BeanManagerImpl manager) {
        return MergedStereotypes.of(annotated.getMetaAnnotations(Stereotype.class), manager);
    }

    public static <T, E> MergedStereotypes<T, E> of(Set<Annotation> stereotypeAnnotations, BeanManagerImpl manager) {
        return new MergedStereotypes<T, E>(stereotypeAnnotations, manager);
    }

    protected MergedStereotypes(Set<Annotation> stereotypeAnnotations, BeanManagerImpl manager) {
        this.manager = manager;
        this.merge(stereotypeAnnotations);
        this.possibleScopeTypes.trimToSize();
        ((ArraySet)Reflections.cast(this.stereotypes)).trimToSize();
        this.stereotypes = SharedObjectCache.instance(manager).getSharedSet(this.stereotypes);
    }

    protected void merge(Set<Annotation> stereotypeAnnotations) {
        MetaAnnotationStore store = (MetaAnnotationStore)this.manager.getServices().get(MetaAnnotationStore.class);
        for (Annotation stereotypeAnnotation : stereotypeAnnotations) {
            StereotypeModel<? extends Annotation> stereotype = store.getStereotype(stereotypeAnnotation.annotationType());
            if (stereotype == null) {
                throw MetadataLogger.LOG.stereotypeNotRegistered(stereotypeAnnotation);
            }
            if (stereotype.isAlternative()) {
                this.alternative = true;
            }
            if (stereotype.getDefaultScopeType() != null) {
                this.possibleScopeTypes.add(stereotype.getDefaultScopeType());
            }
            if (stereotype.isBeanNameDefaulted()) {
                this.beanNameDefaulted = true;
            }
            this.stereotypes.add(stereotypeAnnotation.annotationType());
            this.merge(stereotype.getInheritedStereotypes());
        }
    }

    public boolean isAlternative() {
        return this.alternative;
    }

    public Set<Annotation> getPossibleScopes() {
        return this.possibleScopeTypes;
    }

    public boolean isBeanNameDefaulted() {
        return this.beanNameDefaulted;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return this.stereotypes;
    }

    public String toString() {
        return "Merged stereotype model; Any of the stereotypes is an alternative: " + this.alternative + "; possible scopes " + this.possibleScopeTypes;
    }
}

