/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManagerFactory;
import org.jbpm.kie.services.api.DeploymentIdResolver;
import org.jbpm.kie.services.impl.DeployedUnitImpl;
import org.jbpm.kie.services.impl.audit.ServicesAwareAuditEventBuilder;
import org.jbpm.kie.services.impl.security.IdentityRolesSecurityManager;
import org.jbpm.process.audit.event.AuditEventBuilder;
import org.jbpm.runtime.manager.impl.AbstractRuntimeManager;
import org.jbpm.runtime.manager.impl.SimpleRuntimeEnvironment;
import org.jbpm.services.api.DeploymentEvent;
import org.jbpm.services.api.DeploymentEventListener;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ListenerSupport;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.SecurityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDeploymentService
implements DeploymentService,
ListenerSupport {
    private static Logger logger = LoggerFactory.getLogger(AbstractDeploymentService.class);
    protected RuntimeManagerFactory managerFactory;
    protected RuntimeDataService runtimeDataService;
    protected EntityManagerFactory emf;
    protected IdentityProvider identityProvider;
    protected Set<DeploymentEventListener> listeners = new HashSet<DeploymentEventListener>();
    protected Map<String, DeployedUnit> deploymentsMap = new ConcurrentHashMap<String, DeployedUnit>();

    public void addListener(DeploymentEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(DeploymentEventListener listener) {
        this.listeners.remove(listener);
    }

    public Collection<DeploymentEventListener> getListeners() {
        return Collections.unmodifiableSet(this.listeners);
    }

    public void deploy(DeploymentUnit unit) {
        if (this.deploymentsMap.containsKey(unit.getIdentifier())) {
            throw new IllegalStateException("Unit with id " + unit.getIdentifier() + " is already deployed");
        }
    }

    public void notifyOnDeploy(DeploymentUnit unit, DeployedUnit deployedUnit) {
        DeploymentEvent event = new DeploymentEvent(unit.getIdentifier(), deployedUnit);
        for (DeploymentEventListener listener : this.listeners) {
            listener.onDeploy(event);
        }
    }

    public void notifyOnUnDeploy(DeploymentUnit unit, DeployedUnit deployedUnit) {
        DeploymentEvent event = new DeploymentEvent(unit.getIdentifier(), deployedUnit);
        for (DeploymentEventListener listener : this.listeners) {
            listener.onUnDeploy(event);
        }
    }

    public void notifyOnActivate(DeploymentUnit unit, DeployedUnit deployedUnit) {
        DeploymentEvent event = new DeploymentEvent(unit.getIdentifier(), deployedUnit);
        for (DeploymentEventListener listener : this.listeners) {
            listener.onActivate(event);
        }
    }

    public void notifyOnDeactivate(DeploymentUnit unit, DeployedUnit deployedUnit) {
        DeploymentEvent event = new DeploymentEvent(unit.getIdentifier(), deployedUnit);
        for (DeploymentEventListener listener : this.listeners) {
            listener.onDeactivate(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commonDeploy(DeploymentUnit unit, DeployedUnitImpl deployedUnit, RuntimeEnvironment environemnt, KieContainer kieContainer) {
        AbstractDeploymentService abstractDeploymentService = this;
        synchronized (abstractDeploymentService) {
            if (this.deploymentsMap.containsKey(unit.getIdentifier())) {
                DeployedUnit deployed = this.deploymentsMap.remove(unit.getIdentifier());
                RuntimeManager manager = deployed.getRuntimeManager();
                manager.close();
            }
            RuntimeManager manager = null;
            this.deploymentsMap.put(unit.getIdentifier(), deployedUnit);
            ((SimpleRuntimeEnvironment)environemnt).addToEnvironment("IdentityProvider", (Object)this.identityProvider);
            try {
                switch (unit.getStrategy()) {
                    case SINGLETON: {
                        manager = this.managerFactory.newSingletonRuntimeManager(environemnt, unit.getIdentifier());
                        break;
                    }
                    case PER_REQUEST: {
                        manager = this.managerFactory.newPerRequestRuntimeManager(environemnt, unit.getIdentifier());
                        break;
                    }
                    case PER_PROCESS_INSTANCE: {
                        manager = this.managerFactory.newPerProcessInstanceRuntimeManager(environemnt, unit.getIdentifier());
                        break;
                    }
                    case PER_CASE: {
                        manager = this.managerFactory.newPerCaseRuntimeManager(environemnt, unit.getIdentifier());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid strategy " + unit.getStrategy());
                    }
                }
                ((InternalRuntimeManager)manager).setKieContainer(kieContainer);
                deployedUnit.setRuntimeManager(manager);
                DeploymentDescriptor descriptor = ((InternalRuntimeManager)manager).getDeploymentDescriptor();
                List requiredRoles = descriptor.getRequiredRoles("execute");
                if (requiredRoles != null && !requiredRoles.isEmpty()) {
                    ((InternalRuntimeManager)manager).setSecurityManager((SecurityManager)new IdentityRolesSecurityManager(this.identityProvider, requiredRoles));
                }
                this.notifyOnDeploy(unit, deployedUnit);
            }
            catch (Throwable e) {
                this.deploymentsMap.remove(unit.getIdentifier());
                if (manager != null) {
                    manager.close();
                }
                this.notifyOnUnDeploy(unit, deployedUnit);
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(DeploymentUnit unit) {
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(1);
        states.add(0);
        states.add(4);
        Collection activeProcesses = this.runtimeDataService.getProcessInstancesByDeploymentId(unit.getIdentifier(), states, new QueryContext());
        if (!activeProcesses.isEmpty()) {
            throw new IllegalStateException("Undeploy forbidden - there are active processes instances for deployment " + unit.getIdentifier());
        }
        AbstractDeploymentService abstractDeploymentService = this;
        synchronized (abstractDeploymentService) {
            DeployedUnit deployed = this.deploymentsMap.remove(unit.getIdentifier());
            if (deployed != null) {
                RuntimeManager manager = deployed.getRuntimeManager();
                ((AbstractRuntimeManager)manager).close(true);
            }
            this.notifyOnUnDeploy(unit, deployed);
        }
    }

    public RuntimeManager getRuntimeManager(String deploymentUnitId) {
        if (deploymentUnitId != null && this.deploymentsMap.containsKey(deploymentUnitId)) {
            return this.deploymentsMap.get(deploymentUnitId).getRuntimeManager();
        }
        if (deploymentUnitId != null && deploymentUnitId.toLowerCase().contains("latest")) {
            String matched = DeploymentIdResolver.matchAndReturnLatest(deploymentUnitId, this.deploymentsMap.keySet());
            return this.deploymentsMap.get(matched).getRuntimeManager();
        }
        return null;
    }

    public DeployedUnit getDeployedUnit(String deploymentUnitId) {
        DeployedUnit deployedUnit = null;
        if (this.deploymentsMap.containsKey(deploymentUnitId)) {
            deployedUnit = this.deploymentsMap.get(deploymentUnitId);
        } else if (deploymentUnitId != null && deploymentUnitId.toLowerCase().contains("latest")) {
            String matched = DeploymentIdResolver.matchAndReturnLatest(deploymentUnitId, this.deploymentsMap.keySet());
            deployedUnit = this.deploymentsMap.get(matched);
        }
        return deployedUnit;
    }

    public Map<String, DeployedUnit> getDeploymentsMap() {
        return this.deploymentsMap;
    }

    public Collection<DeployedUnit> getDeployedUnits() {
        return Collections.unmodifiableCollection(this.deploymentsMap.values());
    }

    public RuntimeManagerFactory getManagerFactory() {
        return this.managerFactory;
    }

    public void setManagerFactory(RuntimeManagerFactory managerFactory) {
        this.managerFactory = managerFactory;
    }

    public RuntimeDataService getRuntimeDataService() {
        return this.runtimeDataService;
    }

    public EntityManagerFactory getEmf() {
        return this.emf;
    }

    public void setEmf(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public void setRuntimeDataService(RuntimeDataService runtimeDataService) {
        this.runtimeDataService = runtimeDataService;
    }

    public void setIdentityProvider(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    protected AuditEventBuilder setupAuditLogger(IdentityProvider identityProvider, String deploymentUnitId) {
        ServicesAwareAuditEventBuilder auditEventBuilder = new ServicesAwareAuditEventBuilder();
        auditEventBuilder.setIdentityProvider(identityProvider);
        auditEventBuilder.setDeploymentUnitId(deploymentUnitId);
        return auditEventBuilder;
    }

    public boolean isDeployed(String deploymentUnitId) {
        return this.deploymentsMap.containsKey(deploymentUnitId);
    }

    public void shutdown() {
        Collection<DeployedUnit> deployedUnits = this.getDeployedUnits();
        for (DeployedUnit deployed : deployedUnits) {
            try {
                deployed.getRuntimeManager().close();
            }
            catch (Exception e) {
                logger.warn("Error encountered while shutting down deplyment {} due to {}", (Object)deployed.getDeploymentUnit().getIdentifier(), (Object)e.getMessage());
            }
        }
    }
}

