/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.graph.Graph;
import java.util.HashMap;
import java.util.Map;

@Beta
public final class GraphProperties {
    private GraphProperties() {
    }

    public static boolean isCyclic(Graph<?> graph) {
        Preconditions.checkArgument(graph.isDirected(), "isCyclic() currently only works on directed graphs");
        HashMap<Object, NodeVisitState> nodeToVisitState = Maps.newHashMap();
        for (Object node : graph.nodes()) {
            if (nodeToVisitState.get(node) != null || !GraphProperties.isSubgraphCyclic(graph, nodeToVisitState, node)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSubgraphCyclic(Graph<?> graph, Map<Object, NodeVisitState> nodeToVisitState, Object node) {
        nodeToVisitState.put(node, NodeVisitState.PENDING);
        for (Object successor : graph.successors(node)) {
            NodeVisitState nodeVisitState = nodeToVisitState.get(successor);
            if (nodeVisitState == NodeVisitState.PENDING) {
                return true;
            }
            if (nodeVisitState != null || !GraphProperties.isSubgraphCyclic(graph, nodeToVisitState, successor)) continue;
            return true;
        }
        nodeToVisitState.put(node, NodeVisitState.COMPLETE);
        return false;
    }

    public static <N> ImmutableSet<N> roots(Graph<N> graph) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (N node : graph.nodes()) {
            if (!graph.predecessors(node).isEmpty()) continue;
            builder.add(node);
        }
        return builder.build();
    }

    private static enum NodeVisitState {
        PENDING,
        COMPLETE;

    }
}

