/*
 * Decompiled with CFR 0.152.
 */
package org.kie.config.cli.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.config.cli.command.CliCommand;
import org.kie.config.cli.command.impl.AddDeploymentConfigCliCommand;
import org.kie.config.cli.command.impl.AddRepositoryToOrganizationalUnitCliCommand;
import org.kie.config.cli.command.impl.CreateOrganizationalUnitCliCommand;
import org.kie.config.cli.command.impl.CreateRepositoryCliCommand;
import org.kie.config.cli.command.impl.DiscardCliCommand;
import org.kie.config.cli.command.impl.ExitCliCommand;
import org.kie.config.cli.command.impl.FetchGitRepositoryCliCommand;
import org.kie.config.cli.command.impl.HelpCliCommand;
import org.kie.config.cli.command.impl.ListDeploymentsCliCommand;
import org.kie.config.cli.command.impl.ListOrganizationalUnitCliCommand;
import org.kie.config.cli.command.impl.ListProjectDetailsCliCommand;
import org.kie.config.cli.command.impl.ListRepositoriesCliCommand;
import org.kie.config.cli.command.impl.PushGitRepositoryCliCommand;
import org.kie.config.cli.command.impl.RemoveDeploymentConfigCliCommand;
import org.kie.config.cli.command.impl.RemoveOrganizationalUnitCliCommand;
import org.kie.config.cli.command.impl.RemoveRepositoryCliCommand;
import org.kie.config.cli.command.impl.RemoveRepositoryFromOrganizationalUnitCliCommand;

public class CliCommandRegistry {
    private static CliCommandRegistry instance;
    private Map<String, CliCommand> commands = new HashMap<String, CliCommand>();

    private CliCommandRegistry() {
        this.commands.put("exit", new ExitCliCommand());
        this.commands.put("discard", new DiscardCliCommand());
        this.commands.put("help", new HelpCliCommand());
        this.commands.put("list-deployment", new ListDeploymentsCliCommand());
        this.commands.put("list-repo", new ListRepositoriesCliCommand());
        this.commands.put("list-org-units", new ListOrganizationalUnitCliCommand());
        this.commands.put("create-org-unit", new CreateOrganizationalUnitCliCommand());
        this.commands.put("remove-org-unit", new RemoveOrganizationalUnitCliCommand());
        this.commands.put("add-deployment", new AddDeploymentConfigCliCommand());
        this.commands.put("remove-deployment", new RemoveDeploymentConfigCliCommand());
        this.commands.put("create-repo", new CreateRepositoryCliCommand());
        this.commands.put("remove-repo", new RemoveRepositoryCliCommand());
        this.commands.put("add-repo-org-unit", new AddRepositoryToOrganizationalUnitCliCommand());
        this.commands.put("remove-repo-org-unit", new RemoveRepositoryFromOrganizationalUnitCliCommand());
        this.commands.put("push-changes", new PushGitRepositoryCliCommand());
        this.commands.put("fetch-changes", new FetchGitRepositoryCliCommand());
        this.commands.put("list-project-details", new ListProjectDetailsCliCommand());
    }

    public static CliCommandRegistry get() {
        if (instance == null) {
            instance = new CliCommandRegistry();
        }
        return instance;
    }

    public CliCommand getCommand(String name) {
        return this.commands.get(name);
    }

    public List<String> findMatching(String commandName) {
        ArrayList<String> matched = new ArrayList<String>();
        for (String command : this.commands.keySet()) {
            if (!command.startsWith(commandName)) continue;
            matched.add(command);
        }
        return matched;
    }
}

