/*
 * Decompiled with CFR 0.152.
 */
package org.kie.config.cli.command.impl;

import java.lang.annotation.Annotation;
import java.util.Collection;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Repository;
import org.jboss.weld.environment.se.WeldContainer;
import org.kie.config.cli.CliContext;
import org.kie.config.cli.command.impl.AbstractCliCommand;

public class ListOrganizationalUnitCliCommand
extends AbstractCliCommand {
    @Override
    public String getName() {
        return "list-org-units";
    }

    @Override
    public String execute(CliContext context) {
        StringBuffer result = new StringBuffer();
        WeldContainer container = context.getContainer();
        OrganizationalUnitService organizationalUnitService = (OrganizationalUnitService)container.instance().select(OrganizationalUnitService.class, new Annotation[0]).get();
        Collection groups = organizationalUnitService.getOrganizationalUnits();
        result.append("Currently available Organizational Units: \n");
        for (OrganizationalUnit config : groups) {
            result.append("\tOrganizational Unit " + config.getName() + "\n");
            result.append("\towner: " + config.getOwner() + "\n");
            result.append("\trepositories: \n");
            for (Repository repository : config.getRepositories()) {
                result.append("\t\tRepository " + repository.getAlias() + "\n");
                result.append("\t\t\t scheme: " + repository.getScheme() + "\n");
                result.append("\t\t\t uri: " + repository.getUri() + "\n");
                result.append("\t\t\t environment: " + this.printEnvironment(repository.getEnvironment()) + "\n");
                result.append("\t\t\t repository groups: " + repository.getGroups() + "\n");
            }
        }
        return result.toString();
    }
}

