/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.junit.runners.Parameterized;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.impl.JavaBackedType;
import org.kie.dmn.feel.lang.impl.MapBackedType;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.runtime.BaseFEELCompilerTest;
import test.Address;
import test.Person;

public class FEELStaticTypeTest
extends BaseFEELCompilerTest {
    @Parameterized.Parameters(name="{index}: {0} ({1} | {2}) = {3}")
    public static Collection<Object[]> data() {
        Object[][] cases = new Object[][]{{"{ name : first name + last name }", new HashMap<String, Type>(){
            {
                this.put("first name", BuiltInType.STRING);
                this.put("last name", BuiltInType.STRING);
            }
        }, new HashMap<String, Object>(){
            {
                this.put("first name", "John ");
                this.put("last name", "Doe");
            }
        }, new HashMap<String, Object>(){
            {
                this.put("name", "John Doe");
            }
        }}, {"{ name : person.first name + person.last name }", new HashMap<String, Type>(){
            {
                this.put("person", new MapBackedType().addField("first name", (Type)BuiltInType.STRING).addField("last name", (Type)BuiltInType.STRING));
            }
        }, new HashMap<String, Object>(){
            {
                HashMap<String, String> person = new HashMap<String, String>();
                person.put("first name", "John ");
                person.put("last name", "Doe");
                this.put("person", person);
            }
        }, new HashMap<String, Object>(){
            {
                this.put("name", "John Doe");
            }
        }}, {"{ myFeelVar : person.first name + person.last name }", new HashMap<String, Type>(){
            {
                this.put("person", JavaBackedType.of(Person.class));
            }
        }, new HashMap<String, Object>(){
            {
                this.put("person", new Person("John ", "Doe"));
            }
        }, new HashMap<String, Object>(){
            {
                this.put("myFeelVar", "John Doe");
            }
        }}, {"{ myFeelVar : person.first name + person.last name + \" resides in \" + person.home address.street name }", new HashMap<String, Type>(){
            {
                this.put("person", JavaBackedType.of(Person.class));
            }
        }, new HashMap<String, Object>(){
            {
                this.put("person", new Person("John ", "Doe", new Address("Lumbard St.")));
            }
        }, new HashMap<String, Object>(){
            {
                this.put("myFeelVar", "John Doe resides in Lumbard St.");
            }
        }}, {"{ myFeelVar : person.age }", new HashMap<String, Type>(){
            {
                this.put("person", JavaBackedType.of(Person.class));
            }
        }, new HashMap<String, Object>(){
            {
                this.put("person", new Person("John ", "Doe", 47));
            }
        }, new HashMap<String, Object>(){
            {
                this.put("myFeelVar", new BigDecimal(47));
            }
        }}, {"{ myFeelVar : person.first name + \"zip code is: \" + person.home address.zip }", new HashMap<String, Type>(){
            {
                this.put("person", JavaBackedType.of(Person.class));
            }
        }, new HashMap<String, Object>(){
            {
                this.put("person", new Person("John ", "Doe", new Address("Lumbard St.", "12345")));
            }
        }, new HashMap<String, Object>(){
            {
                this.put("myFeelVar", "John zip code is: 12345");
            }
        }}, {"{ myFeelVar : person.first name + \"home street name is: \" + person.address.street name }", new HashMap<String, Type>(){
            {
                this.put("person", JavaBackedType.of(Person.class));
            }
        }, new HashMap<String, Object>(){
            {
                this.put("person", new Person("John ", "Doe", new Address("Lumbard St.", "12345")));
            }
        }, new HashMap<String, Object>(){
            {
                this.put("myFeelVar", "John home street name is: Lumbard St.");
            }
        }}};
        return Arrays.asList(cases);
    }
}

