/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime;

import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.CompiledExpression;
import org.kie.dmn.feel.lang.CompilerContext;
import org.kie.dmn.feel.lang.Type;

@RunWith(value=Parameterized.class)
public abstract class BaseFEELCompilerTest {
    private final FEEL feel = FEEL.newInstance();
    @Parameterized.Parameter(value=0)
    public String expression;
    @Parameterized.Parameter(value=1)
    public Map<String, Type> inputTypes;
    @Parameterized.Parameter(value=2)
    public Map<String, Object> inputValues;
    @Parameterized.Parameter(value=3)
    public Object result;

    @Test
    public void testExpression() {
        this.assertResult(this.expression, this.inputTypes, this.inputValues, this.result);
    }

    protected void assertResult(String expression, Map<String, Type> inputTypes, Map<String, Object> inputValues, Object result) {
        CompilerContext ctx = this.feel.newCompilerContext();
        inputTypes.forEach((name, type) -> ctx.addInputVariableType(name, type));
        CompiledExpression compiledExpression = this.feel.compile(expression, ctx);
        if (result == null) {
            Assert.assertThat((String)("Evaluating: '" + expression + "'"), (Object)this.feel.evaluate(compiledExpression, inputValues), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        } else if (result instanceof Class) {
            Assert.assertThat((String)("Evaluating: '" + expression + "'"), (Object)this.feel.evaluate(compiledExpression, inputValues), (Matcher)Matchers.is((Matcher)Matchers.instanceOf((Class)((Class)result))));
        } else {
            Assert.assertThat((String)("Evaluating: '" + expression + "'"), (Object)this.feel.evaluate(compiledExpression, inputValues), (Matcher)Matchers.is((Object)result));
        }
    }
}

