/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.ast;

import java.util.List;
import java.util.function.BiPredicate;
import org.antlr.v4.runtime.ParserRuleContext;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.kie.dmn.feel.util.EvalHelper;
import org.kie.dmn.feel.util.Msg;

public class UnaryTestNode
extends BaseNode {
    private UnaryOperator operator;
    private BaseNode value;

    public UnaryTestNode(String op, BaseNode value) {
        this.setText(op + " " + value.getText());
        this.operator = UnaryOperator.determineOperator(op);
        this.value = value;
    }

    public UnaryTestNode(ParserRuleContext ctx, String op, BaseNode value) {
        super(ctx);
        this.operator = UnaryOperator.determineOperator(op);
        this.value = value;
    }

    public UnaryOperator getOperator() {
        return this.operator;
    }

    public void setOperator(UnaryOperator operator) {
        this.operator = operator;
    }

    public BaseNode getValue() {
        return this.value;
    }

    public void setValue(BaseNode value) {
        this.value = value;
    }

    @Override
    public UnaryTest evaluate(EvaluationContext ctx) {
        switch (this.operator) {
            case LTE: {
                return this.createCompareUnaryTest((l, r) -> l.compareTo(r) <= 0);
            }
            case LT: {
                return this.createCompareUnaryTest((l, r) -> l.compareTo(r) < 0);
            }
            case GT: {
                return this.createCompareUnaryTest((l, r) -> l.compareTo(r) > 0);
            }
            case GTE: {
                return this.createCompareUnaryTest((l, r) -> l.compareTo(r) >= 0);
            }
            case EQ: {
                return this.createIsEqualUnaryTest();
            }
            case NE: {
                return this.createIsNotEqualUnaryTest();
            }
            case IN: {
                return this.createInUnaryTest();
            }
            case NOT: {
                return this.createNotUnaryTest();
            }
        }
        ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.NULL_OR_UNKNOWN_OPERATOR)));
        return null;
    }

    private UnaryTest createCompareUnaryTest(BiPredicate<Comparable, Comparable> op) {
        return (context, left) -> {
            Object right = this.value.evaluate((EvaluationContext)context);
            return EvalHelper.compare(left, right, context, op);
        };
    }

    private UnaryTest createIsEqualUnaryTest() {
        return (context, left) -> {
            Object right = this.value.evaluate((EvaluationContext)context);
            return EvalHelper.isEqual(left, right, context);
        };
    }

    private UnaryTest createIsNotEqualUnaryTest() {
        return (context, left) -> {
            Object right = this.value.evaluate((EvaluationContext)context);
            Boolean result = EvalHelper.isEqual(left, right, context);
            return result != null ? Boolean.valueOf(result == false) : null;
        };
    }

    private UnaryTest createInUnaryTest() {
        return (c, o) -> {
            Object val = this.value.evaluate((EvaluationContext)c);
            return o != null && ((Range)val).includes((Comparable)o) != false;
        };
    }

    private UnaryTest createNotUnaryTest() {
        return (c, o) -> {
            Object val = this.value.evaluate((EvaluationContext)c);
            if (val == null) {
                return null;
            }
            List tests = (List)val;
            for (Object test : tests) {
                if (!(test == null ? o == null : (test instanceof UnaryTest ? (Boolean)((UnaryTest)test).apply(c, o) != false : (o == null ? test == null : (test instanceof Range ? ((Range)test).includes((Comparable)o) != false : test.equals(o)))))) continue;
                return false;
            }
            return true;
        };
    }

    public static enum UnaryOperator {
        LTE("<="),
        LT("<"),
        GT(">"),
        GTE(">="),
        NE("!="),
        EQ("="),
        NOT("not"),
        IN("in");

        public final String symbol;

        private UnaryOperator(String symbol) {
            this.symbol = symbol;
        }

        public static UnaryOperator determineOperator(String symbol) {
            for (UnaryOperator op : UnaryOperator.values()) {
                if (!op.symbol.equals(symbol)) continue;
                return op;
            }
            throw new IllegalArgumentException("No operator found for symbol '" + symbol + "'");
        }
    }
}

