/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.runtime.events.FEELEventBase;
import org.kie.dmn.feel.runtime.events.InvalidInputEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaFunction
extends BaseFEELFunction {
    private static final Logger logger = LoggerFactory.getLogger(JavaFunction.class);
    private final List<String> parameters;
    private final Class clazz;
    private final Method method;

    public JavaFunction(String name, List<String> parameters, Class clazz, Method method) {
        super(name);
        this.parameters = parameters;
        this.clazz = clazz;
        this.method = method;
    }

    @Override
    public List<List<String>> getParameterNames() {
        return Arrays.asList(this.parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FEELFnResult<Object> invoke(EvaluationContext ctx, Object[] params) {
        if (params.length != this.parameters.size()) {
            return FEELFnResult.ofError(new InvalidInputEvent(FEELEvent.Severity.ERROR, "Illegal invocation of function", this.getName(), this.getName() + "( " + Arrays.asList(params) + " )", this.getSignature()));
        }
        FEELEventBase capturedException = null;
        try {
            ctx.enterFrame();
            for (int i = 0; i < this.parameters.size(); ++i) {
                ctx.setValue(this.parameters.get(i), params[i]);
            }
            Object[] actualParams = this.prepareParams(params);
            Object result = this.method.invoke((Object)this.clazz, actualParams);
            FEELFnResult<Object> fEELFnResult = FEELFnResult.ofResult(result);
            return fEELFnResult;
        }
        catch (Exception e) {
            capturedException = new FEELEventBase(FEELEvent.Severity.ERROR, "Error invoking function", new RuntimeException("Error invoking function " + this.getSignature() + ".", e));
        }
        finally {
            ctx.exitFrame();
        }
        return FEELFnResult.ofError(capturedException);
    }

    private Object[] prepareParams(Object[] params) {
        Object[] actual = new Object[params.length];
        Class[] paramTypes = this.method.getParameterTypes();
        params = this.adjustForVariableParameters(paramTypes, params);
        for (int i = 0; i < paramTypes.length; ++i) {
            if (paramTypes[i].isAssignableFrom(params[i].getClass())) {
                actual[i] = params[i];
                continue;
            }
            if (params[i] == null) {
                actual[i] = null;
                continue;
            }
            if (params[i] instanceof Number) {
                if (paramTypes[i] == Byte.TYPE || paramTypes[i] == Byte.class) {
                    actual[i] = ((Number)params[i]).byteValue();
                    continue;
                }
                if (paramTypes[i] == Short.TYPE || paramTypes[i] == Short.class) {
                    actual[i] = ((Number)params[i]).shortValue();
                    continue;
                }
                if (paramTypes[i] == Integer.TYPE || paramTypes[i] == Integer.class) {
                    actual[i] = ((Number)params[i]).intValue();
                    continue;
                }
                if (paramTypes[i] == Long.TYPE || paramTypes[i] == Long.class) {
                    actual[i] = ((Number)params[i]).longValue();
                    continue;
                }
                if (paramTypes[i] == Float.TYPE || paramTypes[i] == Float.class) {
                    actual[i] = Float.valueOf(((Number)params[i]).floatValue());
                    continue;
                }
                if (paramTypes[i] == Double.TYPE || paramTypes[i] == Double.class) {
                    actual[i] = ((Number)params[i]).doubleValue();
                    continue;
                }
                throw new IllegalArgumentException("Unable to coerce parameter " + this.parameters.get(0) + ". Expected " + paramTypes[i] + " but found " + params[i].getClass());
            }
            throw new IllegalArgumentException("Unable to coerce parameter " + this.parameters.get(0) + ". Expected " + paramTypes[i] + " but found " + params[i].getClass());
        }
        return actual;
    }

    private Object[] adjustForVariableParameters(Class[] paramTypes, Object[] params) {
        if (paramTypes.length > 0 && paramTypes[paramTypes.length - 1].isArray() && params.length >= paramTypes.length) {
            Object[] remaining;
            Object[] newParams = new Object[paramTypes.length];
            if (newParams.length > 1) {
                System.arraycopy(params, 0, newParams, 0, newParams.length - 1);
            }
            newParams[newParams.length - 1] = remaining = new Object[params.length - paramTypes.length + 1];
            System.arraycopy(params, paramTypes.length - 1, remaining, 0, remaining.length);
            return newParams;
        }
        return params;
    }

    private String getSignature() {
        return this.getName() + "( " + this.parameters.stream().collect(Collectors.joining(", ")) + " )";
    }

    @Override
    protected boolean isCustomFunction() {
        return true;
    }

    public String toString() {
        return "function " + this.getSignature();
    }
}

