/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.impl;

import org.kie.dmn.feel.runtime.Range;

public class RangeImpl
implements Range {
    private Range.RangeBoundary lowBoundary;
    private Range.RangeBoundary highBoundary;
    private Comparable lowEndPoint;
    private Comparable highEndPoint;

    public RangeImpl() {
    }

    public RangeImpl(Range.RangeBoundary lowBoundary, Comparable lowEndPoint, Comparable highEndPoint, Range.RangeBoundary highBoundary) {
        this.lowBoundary = lowBoundary;
        this.highBoundary = highBoundary;
        this.lowEndPoint = lowEndPoint;
        this.highEndPoint = highEndPoint;
    }

    @Override
    public Range.RangeBoundary getLowBoundary() {
        return this.lowBoundary;
    }

    @Override
    public Comparable getLowEndPoint() {
        return this.lowEndPoint;
    }

    @Override
    public Comparable getHighEndPoint() {
        return this.highEndPoint;
    }

    @Override
    public Range.RangeBoundary getHighBoundary() {
        return this.highBoundary;
    }

    @Override
    public Boolean includes(Comparable param) {
        if (this.lowBoundary == Range.RangeBoundary.OPEN && this.highBoundary == Range.RangeBoundary.OPEN) {
            return param == null || this.lowEndPoint == null || this.highEndPoint == null ? null : Boolean.valueOf(param.compareTo(this.lowEndPoint) > 0 && param.compareTo(this.highEndPoint) < 0);
        }
        if (this.lowBoundary == Range.RangeBoundary.OPEN && this.highBoundary == Range.RangeBoundary.CLOSED) {
            return param == null || this.lowEndPoint == null || this.highEndPoint == null ? null : Boolean.valueOf(param.compareTo(this.lowEndPoint) > 0 && param.compareTo(this.highEndPoint) <= 0);
        }
        if (this.lowBoundary == Range.RangeBoundary.CLOSED && this.highBoundary == Range.RangeBoundary.OPEN) {
            return param == null || this.lowEndPoint == null || this.highEndPoint == null ? null : Boolean.valueOf(param.compareTo(this.lowEndPoint) >= 0 && param.compareTo(this.highEndPoint) < 0);
        }
        if (this.lowBoundary == Range.RangeBoundary.CLOSED && this.highBoundary == Range.RangeBoundary.CLOSED) {
            return param == null || this.lowEndPoint == null || this.highEndPoint == null ? null : Boolean.valueOf(param.compareTo(this.lowEndPoint) >= 0 && param.compareTo(this.highEndPoint) <= 0);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RangeImpl)) {
            return false;
        }
        RangeImpl range = (RangeImpl)o;
        if (this.lowBoundary != range.lowBoundary) {
            return false;
        }
        if (this.highBoundary != range.highBoundary) {
            return false;
        }
        if (this.lowEndPoint != null ? !this.lowEndPoint.equals(range.lowEndPoint) : range.lowEndPoint != null) {
            return false;
        }
        return this.highEndPoint != null ? this.highEndPoint.equals(range.highEndPoint) : range.highEndPoint == null;
    }

    public int hashCode() {
        int result = this.lowBoundary != null ? this.lowBoundary.hashCode() : 0;
        result = 31 * result + (this.highBoundary != null ? this.highBoundary.hashCode() : 0);
        result = 31 * result + (this.lowEndPoint != null ? this.lowEndPoint.hashCode() : 0);
        result = 31 * result + (this.highEndPoint != null ? this.highEndPoint.hashCode() : 0);
        return result;
    }

    public String toString() {
        return (this.lowBoundary == Range.RangeBoundary.OPEN ? "(" : "[") + " " + this.lowEndPoint + " .. " + this.highEndPoint + " " + (this.highBoundary == Range.RangeBoundary.OPEN ? ")" : "]");
    }
}

