/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.ast;

import org.antlr.v4.runtime.ParserRuleContext;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.util.Msg;

public class BetweenNode
extends BaseNode {
    private BaseNode value;
    private BaseNode start;
    private BaseNode end;

    public BetweenNode(ParserRuleContext ctx, BaseNode value, BaseNode start, BaseNode end) {
        super(ctx);
        this.value = value;
        this.start = start;
        this.end = end;
    }

    public BaseNode getValue() {
        return this.value;
    }

    public void setValue(BaseNode value) {
        this.value = value;
    }

    public BaseNode getStart() {
        return this.start;
    }

    public void setStart(BaseNode start) {
        this.start = start;
    }

    public BaseNode getEnd() {
        return this.end;
    }

    public void setEnd(BaseNode end) {
        this.end = end;
    }

    @Override
    public Object evaluate(EvaluationContext ctx) {
        boolean problem = false;
        if (this.value == null) {
            ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.IS_NULL, "value")));
            problem = true;
        }
        if (this.start == null) {
            ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.IS_NULL, "start")));
            problem = true;
        }
        if (this.end == null) {
            ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.IS_NULL, "end")));
            problem = true;
        }
        if (problem) {
            return null;
        }
        Comparable val = (Comparable)this.value.evaluate(ctx);
        Comparable s = (Comparable)this.start.evaluate(ctx);
        Comparable e = (Comparable)this.end.evaluate(ctx);
        if (val == null) {
            ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.EVALUATED_TO_NULL, "value")));
            problem = true;
        }
        if (s == null) {
            ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.EVALUATED_TO_NULL, "start")));
            problem = true;
        }
        if (e == null) {
            ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.EVALUATED_TO_NULL, "end")));
            problem = true;
        }
        if (problem) {
            return null;
        }
        if (!val.getClass().isAssignableFrom(s.getClass())) {
            ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.X_TYPE_INCOMPATIBLE_WITH_Y_TYPE, "value", "start")));
            return null;
        }
        if (!val.getClass().isAssignableFrom(e.getClass())) {
            ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.X_TYPE_INCOMPATIBLE_WITH_Y_TYPE, "value", "end")));
            return null;
        }
        return val.compareTo(s) >= 0 && val.compareTo(e) <= 0;
    }
}

