/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.parser.feel11;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.FailedPredicateException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.impl.FEELEventListenersManager;
import org.kie.dmn.feel.parser.feel11.FEEL_1_1Lexer;
import org.kie.dmn.feel.parser.feel11.FEEL_1_1Parser;
import org.kie.dmn.feel.parser.feel11.ParserHelper;
import org.kie.dmn.feel.runtime.events.SyntaxErrorEvent;
import org.kie.dmn.feel.util.Msg;

public class FEELParser {
    private static final List<String> REUSABLE_KEYWORDS = Arrays.asList("for", "return", "if", "then", "else", "some", "every", "satisfies", "instance", "of", "function", "external", "or", "and", "between", "not", "null", "true", "false");
    private static final Pattern DIGITS_PATTERN = Pattern.compile("[0-9]*");

    public static FEEL_1_1Parser parse(FEELEventListenersManager eventsManager, String source, Map<String, Type> inputVariableTypes, Map<String, Object> inputVariables) {
        ANTLRInputStream input = new ANTLRInputStream(source);
        FEEL_1_1Lexer lexer = new FEEL_1_1Lexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        FEEL_1_1Parser parser = new FEEL_1_1Parser((TokenStream)tokens);
        parser.setHelper(new ParserHelper(eventsManager));
        parser.setErrorHandler((ANTLRErrorStrategy)new FEELErrorHandler());
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new FEELParserErrorListener(eventsManager));
        FEELParser.defineVariables(inputVariableTypes, inputVariables, parser);
        return parser;
    }

    public static boolean isVariableNamePartValid(String namePart) {
        return DIGITS_PATTERN.matcher(namePart).matches() || FEELParser.isVariableNameValid(namePart);
    }

    public static boolean isVariableNameValid(String source) {
        return FEELParser.checkVariableName(source).isEmpty();
    }

    public static List<FEELEvent> checkVariableName(String source) {
        if (source == null || source.isEmpty()) {
            return Collections.singletonList(new SyntaxErrorEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.INVALID_VARIABLE_NAME_EMPTY), null, 0, 0, null));
        }
        ANTLRInputStream input = new ANTLRInputStream(source);
        FEEL_1_1Lexer lexer = new FEEL_1_1Lexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        FEEL_1_1Parser parser = new FEEL_1_1Parser((TokenStream)tokens);
        parser.setHelper(new ParserHelper());
        parser.setErrorHandler((ANTLRErrorStrategy)new FEELErrorHandler());
        FEELParserErrorListener errorChecker = new FEELParserErrorListener(null);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorChecker);
        FEEL_1_1Parser.NameDefinitionContext nameDef = parser.nameDefinition();
        if (!errorChecker.hasErrors() && nameDef != null && source.trim().equals(parser.getHelper().getOriginalText(nameDef))) {
            return Collections.emptyList();
        }
        return errorChecker.getErrors();
    }

    private static void defineVariables(Map<String, Type> inputVariableTypes, Map<String, Object> inputVariables, FEEL_1_1Parser parser) {
        inputVariableTypes.forEach((name, type) -> parser.getHelper().defineVariable((String)name, (Type)type));
        inputVariables.forEach((name, value) -> {
            parser.getHelper().defineVariable((String)name);
            if (value instanceof Map) {
                try {
                    parser.getHelper().pushName((String)name);
                    parser.getHelper().pushScope();
                    FEELParser.defineVariables(Collections.EMPTY_MAP, (Map)value, parser);
                }
                finally {
                    parser.getHelper().popScope();
                    parser.getHelper().popName();
                }
            }
        });
    }

    private static SyntaxErrorEvent generateInvalidVariableError(Object offendingSymbol, int line, int charPositionInLine, RecognitionException e, CommonToken token) {
        String chars;
        String string = chars = token.getText().length() == 1 ? "character" : "sequence of characters";
        if (charPositionInLine == 0) {
            if ("in".equals(token.getText()) || REUSABLE_KEYWORDS.contains(token.getText())) {
                return new SyntaxErrorEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.INVALID_VARIABLE_NAME_START, "keyword", token.getText()), e, line, charPositionInLine, offendingSymbol);
            }
            return new SyntaxErrorEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.INVALID_VARIABLE_NAME_START, chars, token.getText()), e, line, charPositionInLine, offendingSymbol);
        }
        if ("in".equals(token.getText())) {
            return new SyntaxErrorEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.INVALID_VARIABLE_NAME, "keyword", token.getText()), e, line, charPositionInLine, offendingSymbol);
        }
        return new SyntaxErrorEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.INVALID_VARIABLE_NAME, chars, token.getText()), e, line, charPositionInLine, offendingSymbol);
    }

    public static class FEELParserErrorListener
    extends BaseErrorListener {
        private final FEELEventListenersManager eventsManager;
        private List<FEELEvent> errors = null;

        public FEELParserErrorListener(FEELEventListenersManager eventsManager) {
            this.eventsManager = eventsManager;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            CommonToken token = (CommonToken)offendingSymbol;
            SyntaxErrorEvent error = ((Parser)recognizer).getRuleInvocationStack().contains("nameDefinition") ? FEELParser.generateInvalidVariableError(offendingSymbol, line, charPositionInLine, e, token) : new SyntaxErrorEvent(FEELEvent.Severity.ERROR, msg, e, line, charPositionInLine, offendingSymbol);
            if (this.eventsManager != null) {
                FEELEventListenersManager.notifyListeners(this.eventsManager, () -> error);
            } else {
                if (this.errors == null) {
                    this.errors = new ArrayList<FEELEvent>();
                }
                this.errors.add(error);
            }
        }

        public boolean hasErrors() {
            return this.errors != null && !this.errors.isEmpty();
        }

        public List<FEELEvent> getErrors() {
            return this.errors;
        }
    }

    public static class FEELErrorHandler
    extends DefaultErrorStrategy {
        protected void reportFailedPredicate(Parser recognizer, FailedPredicateException e) {
        }
    }
}

