/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.util.Arrays;
import java.util.List;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class AnyFunction
extends BaseFEELFunction {
    public AnyFunction() {
        super("any");
    }

    public FEELFnResult<Boolean> invoke(@ParameterName(value="list") List list) {
        boolean result = false;
        for (Object element : list) {
            if (element instanceof Boolean) {
                if (!(result |= ((Boolean)element).booleanValue())) continue;
                break;
            }
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "an element in the list is not a Boolean"));
        }
        return FEELFnResult.ofResult(result);
    }

    public FEELFnResult<Boolean> invoke(@ParameterName(value="list") Boolean single) {
        return FEELFnResult.ofResult(single);
    }

    public FEELFnResult<Boolean> invoke(@ParameterName(value="b") Object[] list) {
        if (list == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "b", "cannot be null"));
        }
        return this.invoke(Arrays.asList(list));
    }
}

