/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class ConcatenateFunction
extends BaseFEELFunction {
    public ConcatenateFunction() {
        super("concatenate");
    }

    public FEELFnResult<List> invoke(@ParameterName(value="list") Object[] lists) {
        if (lists == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "list", "cannot be null"));
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object list : lists) {
            if (list instanceof Collection) {
                result.addAll((Collection)list);
                continue;
            }
            if (list != null) {
                result.add(list);
                continue;
            }
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "list", "on of the element in the list was null"));
        }
        return FEELFnResult.ofResult(result);
    }
}

