/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;
import org.kie.dmn.feel.util.EvalHelper;

public class NumberFunction
extends BaseFEELFunction {
    public NumberFunction() {
        super("number");
    }

    public FEELFnResult<BigDecimal> invoke(@ParameterName(value="from") String from, @ParameterName(value="grouping separator") String group, @ParameterName(value="decimal separator") String decimal) {
        if (from == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "from", "cannot be null"));
        }
        if (!(group == null || group.equals(" ") || group.equals(".") || group.equals(","))) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "group", "not a valid one, can only be one of: dot ('.'), comma (','), space (' ') "));
        }
        if (decimal != null && (!decimal.equals(".") && !decimal.equals(",") || group != null && decimal.equals(group))) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "decimal", "invalid parameter 'decimal' used in conjuction with specified parameter 'group'"));
        }
        if (group != null) {
            from = from.replaceAll("\\" + group, "");
        }
        if (decimal != null) {
            from = from.replaceAll("\\" + decimal, ".");
        }
        try {
            return FEELFnResult.ofResult(EvalHelper.getBigDecimalOrNull(from));
        }
        catch (Exception e) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "unable to calculate final number result", e));
        }
    }
}

