/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions.interval;

import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.interval.FinishedByFunction;
import org.kie.dmn.feel.runtime.impl.RangeImpl;

public class FinishedByFunctionTest {
    private FinishedByFunction finishedByFunction;

    @Before
    public void setUp() {
        this.finishedByFunction = FinishedByFunction.INSTANCE;
    }

    @Test
    public void invokeParamIsNull() {
        FunctionTestUtil.assertResultError(this.finishedByFunction.invoke((Range)null, (Comparable)((Object)"b")), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.finishedByFunction.invoke((Range)new RangeImpl(), (Comparable)null), InvalidParametersEvent.class);
    }

    @Test
    public void invokeParamsCantBeCompared() {
        FunctionTestUtil.assertResultError(this.finishedByFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2), Range.RangeBoundary.CLOSED)), InvalidParametersEvent.class);
    }

    @Test
    public void invokeParamRangeAndSingle() {
        FunctionTestUtil.assertResult(this.finishedByFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Comparable)((Object)"f")), Boolean.TRUE);
        FunctionTestUtil.assertResult(this.finishedByFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Comparable)((Object)"a")), Boolean.FALSE);
        FunctionTestUtil.assertResult(this.finishedByFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.OPEN), (Comparable)((Object)"f")), Boolean.FALSE);
        FunctionTestUtil.assertResult(this.finishedByFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Comparable)((Object)"g")), Boolean.FALSE);
    }

    @Test
    public void invokeParamRangeAndRange() {
        FunctionTestUtil.assertResult(this.finishedByFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED)), Boolean.FALSE);
        FunctionTestUtil.assertResult(this.finishedByFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"c"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED)), Boolean.TRUE);
        FunctionTestUtil.assertResult(this.finishedByFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"e"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"c"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED)), Boolean.FALSE);
        FunctionTestUtil.assertResult(this.finishedByFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"c"), (Comparable)((Object)"f"), Range.RangeBoundary.OPEN)), Boolean.FALSE);
    }
}

