/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.Period;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.junit.runners.Parameterized;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.ast.RangeNode;
import org.kie.dmn.feel.runtime.BaseFEELTest;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.impl.RangeImpl;

public class FEELRangesTest
extends BaseFEELTest {
    @Parameterized.Parameters(name="{index}: {0} ({1}) = {2}")
    public static Collection<Object[]> data() {
        Object[][] cases = new Object[][]{{"[1..2]", new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)BigDecimal.ONE, (Comparable)BigDecimal.valueOf(2L), Range.RangeBoundary.CLOSED), null}, {"[2..1]", new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)BigDecimal.valueOf(2L), (Comparable)BigDecimal.ONE, Range.RangeBoundary.CLOSED), null}, {"[1..2)", new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)BigDecimal.ONE, (Comparable)BigDecimal.valueOf(2L), Range.RangeBoundary.OPEN), null}, {"(1..2]", new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)BigDecimal.ONE, (Comparable)BigDecimal.valueOf(2L), Range.RangeBoundary.CLOSED), null}, {"(1..2)", new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)BigDecimal.ONE, (Comparable)BigDecimal.valueOf(2L), Range.RangeBoundary.OPEN), null}, {"[\"a\"..\"z\"]", new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"z"), Range.RangeBoundary.CLOSED), null}, {"[\"a\"..\"z\")", new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"z"), Range.RangeBoundary.OPEN), null}, {"(\"a\"..\"z\"]", new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)((Object)"a"), (Comparable)((Object)"z"), Range.RangeBoundary.CLOSED), null}, {"(\"a\"..\"z\")", new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)((Object)"a"), (Comparable)((Object)"z"), Range.RangeBoundary.OPEN), null}, {"(\"ab\"..\"yz\")", new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)((Object)"ab"), (Comparable)((Object)"yz"), Range.RangeBoundary.OPEN), null}, {"[\"ab\"+\"cd\"..\"yz\")", new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"abcd"), (Comparable)((Object)"yz"), Range.RangeBoundary.OPEN), null}, {"[(\"ab\"+\"cd\")..\"yz\"]", new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"abcd"), (Comparable)((Object)"yz"), Range.RangeBoundary.CLOSED), null}, {"[date(\"1978-09-12\")..date(\"1978-10-13\")]", new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)LocalDate.of(1978, 9, 12), (Comparable)LocalDate.of(1978, 10, 13), Range.RangeBoundary.CLOSED), null}, {"[date(\"1978-09-12\")..date(\"1978-10-13\"))", new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)LocalDate.of(1978, 9, 12), (Comparable)LocalDate.of(1978, 10, 13), Range.RangeBoundary.OPEN), null}, {"(date(\"1978-09-12\")..date(\"1978-10-13\")]", new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)LocalDate.of(1978, 9, 12), (Comparable)LocalDate.of(1978, 10, 13), Range.RangeBoundary.CLOSED), null}, {"(date(\"1978-09-12\")..date(\"1978-10-13\"))", new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)LocalDate.of(1978, 9, 12), (Comparable)LocalDate.of(1978, 10, 13), Range.RangeBoundary.OPEN), null}, {"[duration(\"P2DT20H14M\")..duration(\"P3DT20H14M\")]", new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Duration.parse("P2DT20H14M"), (Comparable)Duration.parse("P3DT20H14M"), Range.RangeBoundary.CLOSED), null}, {"[duration(\"P2DT20H14M\")..duration(\"P3DT20H14M\"))", new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Duration.parse("P2DT20H14M"), (Comparable)Duration.parse("P3DT20H14M"), Range.RangeBoundary.OPEN), null}, {"(duration(\"P2DT20H14M\")..duration(\"P3DT20H14M\")]", new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Duration.parse("P2DT20H14M"), (Comparable)Duration.parse("P3DT20H14M"), Range.RangeBoundary.CLOSED), null}, {"(duration(\"P2DT20H14M\")..duration(\"P3DT20H14M\"))", new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Duration.parse("P2DT20H14M"), (Comparable)Duration.parse("P3DT20H14M"), Range.RangeBoundary.OPEN), null}, {"(duration(\"P1Y6M\")..duration(\"P2Y6M\"))", new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)new RangeNode.ComparablePeriod(Period.parse("P1Y6M")), (Comparable)new RangeNode.ComparablePeriod(Period.parse("P2Y6M")), Range.RangeBoundary.OPEN), null}, {"[1+2..8]", new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)BigDecimal.valueOf(3L), (Comparable)BigDecimal.valueOf(8L), Range.RangeBoundary.CLOSED), null}, {"[1+2..8)", new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)BigDecimal.valueOf(3L), (Comparable)BigDecimal.valueOf(8L), Range.RangeBoundary.OPEN), null}, {"(1+2..8]", new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)BigDecimal.valueOf(3L), (Comparable)BigDecimal.valueOf(8L), Range.RangeBoundary.CLOSED), null}, {"(1+2..8)", new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)BigDecimal.valueOf(3L), (Comparable)BigDecimal.valueOf(8L), Range.RangeBoundary.OPEN), null}, {"[3..2+6]", new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)BigDecimal.valueOf(3L), (Comparable)BigDecimal.valueOf(8L), Range.RangeBoundary.CLOSED), null}, {"[3..2+6)", new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)BigDecimal.valueOf(3L), (Comparable)BigDecimal.valueOf(8L), Range.RangeBoundary.OPEN), null}, {"(3..2+6]", new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)BigDecimal.valueOf(3L), (Comparable)BigDecimal.valueOf(8L), Range.RangeBoundary.CLOSED), null}, {"(3..2+6)", new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)BigDecimal.valueOf(3L), (Comparable)BigDecimal.valueOf(8L), Range.RangeBoundary.OPEN), null}, {"[3..(2+6)]", new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)BigDecimal.valueOf(3L), (Comparable)BigDecimal.valueOf(8L), Range.RangeBoundary.CLOSED), null}, {"[(1+2)..8]", new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)BigDecimal.valueOf(3L), (Comparable)BigDecimal.valueOf(8L), Range.RangeBoundary.CLOSED), null}, {"[max( 1, 2, 3 )..8]", new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)BigDecimal.valueOf(3L), (Comparable)BigDecimal.valueOf(8L), Range.RangeBoundary.CLOSED), null}, {"[max( 1, 2, 3 )+1..8]", new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)BigDecimal.valueOf(4L), (Comparable)BigDecimal.valueOf(8L), Range.RangeBoundary.CLOSED), null}, {"[1..\"cheese\"]", null, FEELEvent.Severity.ERROR}, {"[1..date(\"1978-09-12\")]", null, FEELEvent.Severity.ERROR}, {"[([1, 2, 3, 4][4])..8]", new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)BigDecimal.valueOf(4L), (Comparable)BigDecimal.valueOf(8L), Range.RangeBoundary.CLOSED), null}, {"{ x: 3, numberrange: [1+x..8]}", new HashMap<String, Object>(){
            {
                this.put("x", BigDecimal.valueOf(3L));
                this.put("numberrange", new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)BigDecimal.valueOf(4L), (Comparable)BigDecimal.valueOf(8L), Range.RangeBoundary.CLOSED));
            }
        }, null}, {"{ start: 1, end: 2, numberrange: [start..end] }", new HashMap<String, Object>(){
            {
                this.put("start", BigDecimal.ONE);
                this.put("end", BigDecimal.valueOf(2L));
                this.put("numberrange", new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)BigDecimal.ONE, (Comparable)BigDecimal.valueOf(2L), Range.RangeBoundary.CLOSED));
            }
        }, null}, {"{ start: 1, end: max( 1, 2, 3 ), numberrange: [start..end] }", new HashMap<String, Object>(){
            {
                this.put("start", BigDecimal.ONE);
                this.put("end", BigDecimal.valueOf(3L));
                this.put("numberrange", new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)BigDecimal.ONE, (Comparable)BigDecimal.valueOf(3L), Range.RangeBoundary.CLOSED));
            }
        }, null}, {"{ start: max( 1, 2, 3 ) + 1, end: 8, numberrange: [start..end] }", new HashMap<String, Object>(){
            {
                this.put("start", BigDecimal.valueOf(4L));
                this.put("end", BigDecimal.valueOf(8L));
                this.put("numberrange", new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)BigDecimal.valueOf(4L), (Comparable)BigDecimal.valueOf(8L), Range.RangeBoundary.CLOSED));
            }
        }, null}, {"{ start: \"a\", end: \"z\", charrange: [start..end] }", new HashMap<String, Object>(){
            {
                this.put("start", "a");
                this.put("end", "z");
                this.put("charrange", new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"z"), Range.RangeBoundary.CLOSED));
            }
        }, null}, {"{ startdate: date(\"1978-09-12\"), enddate: date(\"1978-10-13\"), rangedates: [startdate..enddate] }", new HashMap<String, Object>(){
            {
                this.put("startdate", LocalDate.of(1978, 9, 12));
                this.put("enddate", LocalDate.of(1978, 10, 13));
                this.put("rangedates", new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)LocalDate.of(1978, 9, 12), (Comparable)LocalDate.of(1978, 10, 13), Range.RangeBoundary.CLOSED));
            }
        }, null}};
        return Arrays.asList(cases);
    }
}

