/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;
import org.kie.dmn.feel.runtime.functions.SumFunction;
import org.kie.dmn.feel.util.EvalHelper;

public class MeanFunction
extends BaseFEELFunction {
    private SumFunction sum = new SumFunction();

    public MeanFunction() {
        super("mean");
    }

    public FEELFnResult<BigDecimal> invoke(@ParameterName(value="list") List list) {
        FEELFnResult<BigDecimal> s = this.sum.invoke(list);
        Function<FEELEvent, FEELFnResult> ifLeft = event -> FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "list", "unable to sum the elements which is required to calculate the mean"));
        Function<BigDecimal, FEELFnResult> ifRight = sum -> {
            try {
                return FEELFnResult.ofResult(sum.divide(BigDecimal.valueOf(list.size()), MathContext.DECIMAL128));
            }
            catch (Exception e) {
                return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "unable to perform division to calculate the mean", e));
            }
        };
        return s.cata(ifLeft, ifRight);
    }

    public FEELFnResult<BigDecimal> invoke(@ParameterName(value="list") Number single) {
        if (single == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "list", "the single value list cannot be null"));
        }
        if (single instanceof BigDecimal) {
            return FEELFnResult.ofResult((BigDecimal)single);
        }
        BigDecimal result = EvalHelper.getBigDecimalOrNull(single);
        if (result != null) {
            return FEELFnResult.ofResult(result);
        }
        return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "list", "single element in list not a number"));
    }

    public FEELFnResult<BigDecimal> invoke(@ParameterName(value="n") Object[] list) {
        if (list == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "n", "cannot be null"));
        }
        return this.invoke(Arrays.asList(list));
    }
}

