/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.DateTimeFunction;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;

public class DateTimeFunctionTest {
    private DateTimeFunction dateTimeFunction;

    @Before
    public void setUp() {
        this.dateTimeFunction = new DateTimeFunction();
    }

    @Test
    public void invokeParamStringNull() {
        FunctionTestUtil.assertResultError(this.dateTimeFunction.invoke(null), InvalidParametersEvent.class);
    }

    @Test
    public void invokeParamStringNotDateOrTime() {
        FunctionTestUtil.assertResultError(this.dateTimeFunction.invoke("test"), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.dateTimeFunction.invoke("2017-09-test"), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.dateTimeFunction.invoke("2017-09-T89"), InvalidParametersEvent.class);
    }

    @Test
    public void invokeParamStringDateTime() {
        FunctionTestUtil.assertResult(this.dateTimeFunction.invoke("2017-09-07T10:20:30"), LocalDateTime.of(2017, 9, 7, 10, 20, 30));
    }

    @Test
    public void invokeParamStringDate() {
        FunctionTestUtil.assertResult(this.dateTimeFunction.invoke("2017-09-07"), LocalDateTime.of(2017, 9, 7, 0, 0, 0));
    }

    @Test
    public void invokeParamTemporalNulls() {
        FunctionTestUtil.assertResultError(this.dateTimeFunction.invoke((Temporal)null, null), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.dateTimeFunction.invoke(null, (Temporal)LocalTime.of(10, 6, 20)), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.dateTimeFunction.invoke((Temporal)LocalDate.of(2017, 6, 12), null), InvalidParametersEvent.class);
    }

    @Test
    public void invokeParamTemporalWrongTemporal() {
        FunctionTestUtil.assertResultError(this.dateTimeFunction.invoke((Temporal)LocalDateTime.of(2017, 6, 12, 0, 0), (Temporal)LocalTime.of(10, 6, 20)), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.dateTimeFunction.invoke((Temporal)LocalDate.of(2017, 6, 12), (Temporal)LocalDateTime.of(2017, 6, 12, 0, 0)), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.dateTimeFunction.invoke((Temporal)LocalDateTime.of(2017, 6, 12, 0, 0), (Temporal)LocalDateTime.of(2017, 6, 12, 0, 0)), InvalidParametersEvent.class);
    }

    @Test
    public void invokeParamTemporalLocalTime() {
        FunctionTestUtil.assertResult(this.dateTimeFunction.invoke((Temporal)LocalDate.of(2017, 6, 12), (Temporal)LocalTime.of(10, 6, 20)), LocalDateTime.of(2017, 6, 12, 10, 6, 20));
    }

    @Test
    public void invokeParamTemporalOffsetTime() {
        FunctionTestUtil.assertResult(this.dateTimeFunction.invoke((Temporal)LocalDate.of(2017, 6, 12), (Temporal)OffsetTime.of(10, 6, 20, 0, ZoneOffset.UTC)), ZonedDateTime.of(2017, 6, 12, 10, 6, 20, 0, ZoneOffset.UTC));
    }
}

