/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.documentation;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.ast.Block;
import org.asciidoctor.ast.ContentNode;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.Section;
import org.asciidoctor.ast.StructuralNode;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.FEELProfile;
import org.kie.dmn.feel.parser.feel11.profiles.KieExtendedFEELProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ADocFEELExamplesTest {
    private static final Logger LOG = LoggerFactory.getLogger(ADocFEELExamplesTest.class);
    private static final List<FEELProfile> profiles = new ArrayList<FEELProfile>();
    private final FEEL feel;

    public ADocFEELExamplesTest() {
        profiles.add((FEELProfile)new KieExtendedFEELProfile());
        this.feel = FEEL.newInstance(profiles);
    }

    @Test
    public void test() throws URISyntaxException {
        Asciidoctor asciidoctor = Asciidoctor.Factory.create();
        URL resource = this.getClass().getResource("/FEELbuiltinfunctions.adoc");
        URI uri = resource.toURI();
        LOG.debug("{}", (Object)uri);
        File src = new File(uri);
        Document loadFile = asciidoctor.loadFile(src, OptionsBuilder.options().asMap());
        this.processBlock((StructuralNode)loadFile);
    }

    private void processBlock(StructuralNode block) {
        List blocks = block.getBlocks();
        for (int i = 0; i < blocks.size(); ++i) {
            StructuralNode currentBlock = (StructuralNode)blocks.get(i);
            if (!(currentBlock instanceof StructuralNode)) continue;
            if ("listing".equals(currentBlock.getContext())) {
                Block b = (Block)currentBlock;
                List lines = b.getLines();
                LOG.trace("{}", (Object)lines);
                LOG.trace("{}", (Object)b.getAttributes());
                ContentNode parent = b.getParent();
                String sectionTitle = "";
                if (parent instanceof Section) {
                    Section section = (Section)parent;
                    sectionTitle = section.getTitle();
                }
                if (b.getAttribute((Object)"language", (Object)"unknown").equals("FEEL")) {
                    for (String l : lines) {
                        String titled = sectionTitle + ": " + l;
                        LOG.info("checking DOC {}", (Object)titled);
                        Object FEELResult = this.feel.evaluate(l);
                        Assert.assertThat((String)titled, (Object)FEELResult, (Matcher)Matchers.is((Object)true));
                    }
                    continue;
                }
                LOG.trace("This block is not FEEL true predicate snippets: {}", (Object)b);
                continue;
            }
            this.processBlock(currentBlock);
        }
    }
}

