/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.api.feel.runtime.events.FEELEventListener;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.CompilerContext;
import org.kie.dmn.feel.runtime.events.SyntaxErrorEvent;
import org.kie.dmn.feel.runtime.events.UnknownVariableErrorEvent;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class FEELErrorMessagesTest {
    @Test
    public void unknownVariable() {
        FEEL feel = FEEL.newInstance();
        FEELEventListener fel = (FEELEventListener)Mockito.mock(FEELEventListener.class);
        feel.addListener(fel);
        CompilerContext ctx = feel.newCompilerContext();
        feel.compile("a variable name", ctx);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FEELEvent.class);
        ((FEELEventListener)Mockito.verify((Object)fel, (VerificationMode)Mockito.times((int)2))).onEvent((FEELEvent)captor.capture());
        Assert.assertThat((Object)captor.getAllValues().size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat(captor.getAllValues().get(1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(UnknownVariableErrorEvent.class)));
        Assert.assertThat((Object)((UnknownVariableErrorEvent)captor.getAllValues().get(1)).getOffendingSymbol(), (Matcher)CoreMatchers.is((Object)"a variable name"));
    }

    @Test
    public void ifWithoutElse() {
        FEEL feel = FEEL.newInstance();
        FEELEventListener fel = (FEELEventListener)Mockito.mock(FEELEventListener.class);
        feel.addListener(fel);
        CompilerContext ctx = feel.newCompilerContext();
        feel.compile("if true then 123", ctx);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FEELEvent.class);
        ((FEELEventListener)Mockito.verify((Object)fel, (VerificationMode)Mockito.times((int)1))).onEvent((FEELEvent)captor.capture());
        Assert.assertThat((Object)captor.getAllValues().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(captor.getAllValues().get(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(SyntaxErrorEvent.class)));
        Assert.assertThat((Object)((SyntaxErrorEvent)captor.getAllValues().get(0)).getMessage(), (Matcher)CoreMatchers.startsWith((String)"Detected 'if' expression without 'else' part"));
    }

    @Test
    public void ifWithoutElse2() {
        FEEL feel = FEEL.newInstance();
        FEELEventListener fel = (FEELEventListener)Mockito.mock(FEELEventListener.class);
        feel.addListener(fel);
        CompilerContext ctx = feel.newCompilerContext();
        feel.compile("if true then 123 456", ctx);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FEELEvent.class);
        ((FEELEventListener)Mockito.verify((Object)fel, (VerificationMode)Mockito.times((int)1))).onEvent((FEELEvent)captor.capture());
        Assert.assertThat((Object)captor.getAllValues().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(captor.getAllValues().get(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(SyntaxErrorEvent.class)));
        Assert.assertThat((Object)((SyntaxErrorEvent)captor.getAllValues().get(0)).getMessage(), (Matcher)CoreMatchers.is((Object)"missing 'else' at '456'"));
    }

    @Test
    public void ifWithoutThen() {
        FEEL feel = FEEL.newInstance();
        FEELEventListener fel = (FEELEventListener)Mockito.mock(FEELEventListener.class);
        feel.addListener(fel);
        CompilerContext ctx = feel.newCompilerContext();
        feel.compile("if true", ctx);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FEELEvent.class);
        ((FEELEventListener)Mockito.verify((Object)fel, (VerificationMode)Mockito.times((int)1))).onEvent((FEELEvent)captor.capture());
        Assert.assertThat((Object)captor.getAllValues().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(captor.getAllValues().get(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(SyntaxErrorEvent.class)));
        Assert.assertThat((Object)((SyntaxErrorEvent)captor.getAllValues().get(0)).getMessage(), (Matcher)CoreMatchers.startsWith((String)"Detected 'if' expression without 'then' part"));
    }

    @Test
    public void ifWithoutThen2() {
        FEEL feel = FEEL.newInstance();
        FEELEventListener fel = (FEELEventListener)Mockito.mock(FEELEventListener.class);
        feel.addListener(fel);
        CompilerContext ctx = feel.newCompilerContext();
        feel.compile("if true 123", ctx);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FEELEvent.class);
        ((FEELEventListener)Mockito.verify((Object)fel, (VerificationMode)Mockito.times((int)2))).onEvent((FEELEvent)captor.capture());
        Assert.assertThat((Object)captor.getAllValues().size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat(captor.getAllValues().get(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(SyntaxErrorEvent.class)));
        Assert.assertThat((Object)((SyntaxErrorEvent)captor.getAllValues().get(0)).getMessage(), (Matcher)CoreMatchers.startsWith((String)"missing 'then' at '123'"));
        Assert.assertThat(captor.getAllValues().get(1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(SyntaxErrorEvent.class)));
        Assert.assertThat((Object)((SyntaxErrorEvent)captor.getAllValues().get(1)).getMessage(), (Matcher)CoreMatchers.startsWith((String)"Detected 'if' expression without 'then' part"));
    }
}

