/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.CeilingFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;

public class CeilingFunctionTest {
    private CeilingFunction ceilingFunction;

    @Before
    public void setUp() {
        this.ceilingFunction = new CeilingFunction();
    }

    @Test
    public void invokeNull() {
        FunctionTestUtil.assertResultError(this.ceilingFunction.invoke(null), InvalidParametersEvent.class);
    }

    @Test
    public void invokeZero() {
        FunctionTestUtil.assertResultBigDecimal((FEELFnResult<BigDecimal>)this.ceilingFunction.invoke(BigDecimal.ZERO), BigDecimal.ZERO);
    }

    @Test
    public void invokePositive() {
        FunctionTestUtil.assertResultBigDecimal((FEELFnResult<BigDecimal>)this.ceilingFunction.invoke(BigDecimal.valueOf(10.2)), BigDecimal.valueOf(11L));
    }

    @Test
    public void invokeNegative() {
        FunctionTestUtil.assertResultBigDecimal((FEELFnResult<BigDecimal>)this.ceilingFunction.invoke(BigDecimal.valueOf(-10.2)), BigDecimal.valueOf(-10L));
    }
}

