/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.marshaller;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.lang.types.impl.ComparablePeriod;
import org.kie.dmn.feel.marshaller.FEELStringMarshaller;

@RunWith(value=Parameterized.class)
public class FEELStringMarshallerUnmarshallTest {
    @Parameterized.Parameter(value=0)
    public Type feelType;
    @Parameterized.Parameter(value=1)
    public String value;
    @Parameterized.Parameter(value=2)
    public Object result;

    @Parameterized.Parameters(name="{index}: {0} ({1}) = {2}")
    public static Collection<Object[]> data() {
        Object[][] cases = new Object[][]{{BuiltInType.NUMBER, "2", BigDecimal.valueOf(2L)}, {BuiltInType.NUMBER, "2.0", BigDecimal.valueOf(2.0)}, {BuiltInType.NUMBER, "0.2", BigDecimal.valueOf(0.2)}, {BuiltInType.NUMBER, "0.2", BigDecimal.valueOf(0.2)}, {BuiltInType.NUMBER, "-0.2", BigDecimal.valueOf(-0.2)}, {BuiltInType.STRING, "foo", "foo"}, {BuiltInType.STRING, "", ""}, {BuiltInType.BOOLEAN, "true", true}, {BuiltInType.BOOLEAN, "false", false}, {BuiltInType.DATE, "2017-07-01", LocalDate.of(2017, 7, 1)}, {BuiltInType.TIME, "14:32:55", LocalTime.of(14, 32, 55)}, {BuiltInType.TIME, "14:32:55.125-05:00", OffsetTime.of(14, 32, 55, 125000000, ZoneOffset.ofHours(-5))}, {BuiltInType.TIME, "14:32:55.125Z", OffsetTime.of(14, 32, 55, 125000000, ZoneOffset.UTC)}, {BuiltInType.DATE_TIME, "2017-06-30T10:49:11", LocalDateTime.of(2017, 6, 30, 10, 49, 11)}, {BuiltInType.DATE_TIME, "2017-06-30T10:49:11.650", LocalDateTime.of(2017, 6, 30, 10, 49, 11, 650000000)}, {BuiltInType.DATE_TIME, "2017-06-30T10:49:11.650+03:00", ZonedDateTime.of(2017, 6, 30, 10, 49, 11, 650000000, ZoneOffset.ofHours(3))}, {BuiltInType.DURATION, "P5DT4H23M55S", Duration.ofDays(5L).plusHours(4L).plusMinutes(23L).plusSeconds(55L)}, {BuiltInType.DURATION, "-P5DT4H23M55S", Duration.ofDays(-5L).minusHours(4L).minusMinutes(23L).minusSeconds(55L)}, {BuiltInType.DURATION, "P23D", Duration.ofDays(23L)}, {BuiltInType.DURATION, "-P23D", Duration.ofDays(-23L)}, {BuiltInType.DURATION, "PT23H", Duration.ofHours(23L)}, {BuiltInType.DURATION, "-PT23H", Duration.ofHours(-23L)}, {BuiltInType.DURATION, "PT23M", Duration.ofMinutes(23L)}, {BuiltInType.DURATION, "-PT23M", Duration.ofMinutes(-23L)}, {BuiltInType.DURATION, "PT23S", Duration.ofSeconds(23L)}, {BuiltInType.DURATION, "-PT23S", Duration.ofSeconds(-23L)}, {BuiltInType.DURATION, "PT0S", Duration.ofDays(0L)}, {BuiltInType.DURATION, "P5DT4H", Duration.ofHours(124L)}, {BuiltInType.DURATION, "P737DT20H8M3S", Duration.ofSeconds(63749283L)}, {BuiltInType.DURATION, "P4Y5M", ComparablePeriod.of((int)4, (int)5, (int)0)}, {BuiltInType.DURATION, "P6Y1M", ComparablePeriod.of((int)6, (int)1, (int)0)}, {BuiltInType.DURATION, "-P6Y1M", ComparablePeriod.of((int)-6, (int)-1, (int)0)}, {BuiltInType.DURATION, "P0M", ComparablePeriod.of((int)0, (int)0, (int)0)}, {BuiltInType.UNKNOWN, "null", null}};
        return Arrays.asList(cases);
    }

    @Test
    public void testExpression() {
        this.assertResult(this.feelType, this.value, this.result);
    }

    protected void assertResult(Type feelType, String value, Object result) {
        if (result == null) {
            MatcherAssert.assertThat((String)("Unmarshalling: '" + value + "'"), (Object)FEELStringMarshaller.INSTANCE.unmarshall(feelType, value), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        } else {
            MatcherAssert.assertThat((String)("Unmarshalling: '" + value + "'"), (Object)FEELStringMarshaller.INSTANCE.unmarshall(feelType, value), (Matcher)Matchers.is((Object)result));
        }
    }
}

