/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.codegen.feel11;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.kie.dmn.feel.codegen.feel11.CodegenTestUtil;
import org.kie.dmn.feel.codegen.feel11.CompiledFEELExpression;
import org.kie.dmn.feel.codegen.feel11.CompiledFEELSupport;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManualForTest {
    public static final Logger LOG = LoggerFactory.getLogger(ManualForTest.class);

    @Test
    public void testManualContext() {
        ManualFilterExpression compiledExpression = new ManualFilterExpression();
        LOG.debug("{}", (Object)compiledExpression);
        EvaluationContext emptyContext = CodegenTestUtil.newEmptyEvaluationContext();
        Object result = compiledExpression.apply(emptyContext);
        LOG.debug("{}", result);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is(Arrays.asList(BigDecimal.valueOf(10L), BigDecimal.valueOf(20L), BigDecimal.valueOf(30L), BigDecimal.valueOf(20L), BigDecimal.valueOf(40L), BigDecimal.valueOf(60L), BigDecimal.valueOf(30L), BigDecimal.valueOf(60L), BigDecimal.valueOf(90L))));
    }

    public static class ManualFilterExpression
    implements CompiledFEELExpression {
        public static final BigDecimal K_1 = new BigDecimal(1, MathContext.DECIMAL128);
        public static final BigDecimal K_2 = new BigDecimal(2, MathContext.DECIMAL128);
        public static final BigDecimal K_3 = new BigDecimal(3, MathContext.DECIMAL128);
        public static final BigDecimal K_10 = new BigDecimal(10, MathContext.DECIMAL128);
        public static final BigDecimal K_20 = new BigDecimal(20, MathContext.DECIMAL128);
        public static final BigDecimal K_30 = new BigDecimal(30, MathContext.DECIMAL128);

        public Object apply(EvaluationContext feelExprCtx) {
            return CompiledFEELSupport.ffor((EvaluationContext)feelExprCtx).with(c -> "x", c -> Arrays.asList(K_10, K_20, K_30)).with(c -> "y", c -> Arrays.asList(K_1, K_2, K_3)).rreturn(c -> ((BigDecimal)feelExprCtx.getValue("x")).multiply((BigDecimal)feelExprCtx.getValue("y")));
        }
    }
}

