/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.examples;

import java.math.BigDecimal;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.examples.ExamplesBaseTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExamplesTest
extends ExamplesBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(ExamplesTest.class);
    private static Map context;
    private static FEEL feel;

    @BeforeClass
    public static void setupTest() {
        String expression = ExamplesTest.loadExpression("example_10_6_1.feel");
        feel = FEEL.newInstance();
        context = (Map)feel.evaluate(expression);
    }

    @Test
    public void testLoadApplicantContext() {
        String expression = ExamplesTest.loadExpression("applicant.feel");
        Map applicant = (Map)feel.evaluate(expression);
        System.out.println(this.printContext(applicant));
        MatcherAssert.assertThat((Object)applicant.size(), (Matcher)CoreMatchers.is((Object)5));
    }

    @Test
    public void testLoadExample_10_6_1() {
        System.out.println(this.printContext(context));
        MatcherAssert.assertThat((Object)context.size(), (Matcher)CoreMatchers.is((Object)6));
    }

    @Test
    public void testLoadExample_10_6_2() {
        Number yearlyIncome = (Number)feel.evaluate("monthly income * 12", context);
        System.out.println("Yearly income = " + yearlyIncome);
        MatcherAssert.assertThat((Object)yearlyIncome, (Matcher)CoreMatchers.is((Object)new BigDecimal("120000.00")));
    }

    @Test
    public void testLoadExample_10_6_3() {
        String expression = ExamplesTest.loadExpression("example_10_6_3.feel");
        String maritalStatus = (String)feel.evaluate(expression, context);
        System.out.println("Marital status = " + maritalStatus);
        MatcherAssert.assertThat((Object)maritalStatus, (Matcher)CoreMatchers.is((Object)"valid"));
    }

    @Test
    public void testLoadExample_10_6_4() {
        Number totalExpenses = (Number)feel.evaluate("sum( monthly outgoings )", context);
        System.out.println("Monthly total expenses = " + totalExpenses);
        MatcherAssert.assertThat((Object)totalExpenses, (Matcher)CoreMatchers.is((Object)new BigDecimal("5500.00")));
    }

    @Test
    public void testLoadExample_10_6_5() {
        String expression = ExamplesTest.loadExpression("example_10_6_5.feel");
        Number pmt = (Number)feel.evaluate(expression, context);
        System.out.println("PMT = " + pmt);
        MatcherAssert.assertThat((Object)pmt, (Matcher)CoreMatchers.is((Object)new BigDecimal("3975.982590125552338278440100112431")));
    }

    @Test
    public void testLoadExample_10_6_6() {
        String expression = ExamplesTest.loadExpression("example_10_6_6.feel");
        Number total = (Number)feel.evaluate(expression, context);
        System.out.println("Weight = " + total);
        MatcherAssert.assertThat((Object)total, (Matcher)CoreMatchers.is((Object)new BigDecimal("150")));
    }

    @Test
    public void testLoadExample_10_6_7() {
        String expression = ExamplesTest.loadExpression("example_10_6_7.feel");
        Boolean bankrupcy = (Boolean)feel.evaluate(expression, context);
        System.out.println("Is there bankrupcy event? " + bankrupcy);
        MatcherAssert.assertThat((Object)bankrupcy, (Matcher)CoreMatchers.is((Object)Boolean.FALSE));
    }

    @Test
    public void testJavaCall() {
        String expression = ExamplesTest.loadExpression("javacall.feel");
        Map context = (Map)feel.evaluate(expression);
        System.out.println(this.printContext(context));
    }

    @Test
    public void testAdhocExpression() {
        String expression = ExamplesTest.loadExpression("custom.feel");
        Object result = feel.evaluate(expression);
        if (result instanceof Map) {
            System.out.println(this.printContext((Map)result));
        } else {
            System.out.println("Result: " + result);
        }
    }
}

