/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime;

import java.math.BigDecimal;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.junit.runners.Parameterized;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.BaseFEELTest;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.impl.RangeImpl;

public class FEELListsTest
extends BaseFEELTest {
    @Parameterized.Parameters(name="{index}: {0} ({1}) = {2}")
    public static Collection<Object[]> data() {
        Object[][] cases = new Object[][]{{"[ 5, 10+2, \"foo\"+\"bar\", true ]", Arrays.asList(BigDecimal.valueOf(5L), BigDecimal.valueOf(12L), "foobar", Boolean.TRUE), null}, {"[\"a\", \"b\", \"c\"][1]", "a", null}, {"[\"a\", \"b\", \"c\"][2]", "b", null}, {"[\"a\", \"b\", \"c\"][3]", "c", null}, {"[\"a\", \"b\", \"c\"][-1]", "c", null}, {"[\"a\", \"b\", \"c\"][-2]", "b", null}, {"[\"a\", \"b\", \"c\"][-3]", "a", null}, {"[\"a\", \"b\", \"c\"][4]", null, FEELEvent.Severity.ERROR}, {"[\"a\", \"b\", \"c\"][984]", null, FEELEvent.Severity.ERROR}, {"[\"a\", \"b\", \"c\"][-4]", null, FEELEvent.Severity.ERROR}, {"[\"a\", \"b\", \"c\"][-984]", null, FEELEvent.Severity.ERROR}, {"\"a\"[1]", "a", null}, {"\"a\"[2]", null, FEELEvent.Severity.ERROR}, {"\"a\"[-1]", "a", null}, {"\"a\"[-2]", null, FEELEvent.Severity.ERROR}, {"{ a list : [10, 20, 30, 40], second : a list[2] }.second", BigDecimal.valueOf(20L), null}, {"[1, 2, 3, 4][item = 4]", Arrays.asList(BigDecimal.valueOf(4L)), null}, {"[1, 2, 3, 4][item > 2]", Arrays.asList(BigDecimal.valueOf(3L), BigDecimal.valueOf(4L)), null}, {"[1, 2, 3, 4][item > 5]", Collections.emptyList(), null}, {"[ {x:1, y:2}, {x:2, y:3} ][x = 1]", Arrays.asList(new HashMap<String, Object>(){
            {
                this.put("x", BigDecimal.valueOf(1L));
                this.put("y", BigDecimal.valueOf(2L));
            }
        }), null}, {"[ {x:1, y:2}, {x:2, y:3} ][x > 1]", Arrays.asList(new HashMap<String, Object>(){
            {
                this.put("x", BigDecimal.valueOf(1L));
                this.put("y", BigDecimal.valueOf(2L));
                this.put("x", BigDecimal.valueOf(2L));
                this.put("y", BigDecimal.valueOf(3L));
            }
        }), null}, {"[ {x:1, y:2}, {x:2, y:3} ][x = 0]", Collections.emptyList(), null}, {"[\"a\", \"b\", \"c\"][a]", null, FEELEvent.Severity.ERROR}, {"[ {x:1, y:2}, {x:2, y:3} ].y", Arrays.asList(BigDecimal.valueOf(2L), BigDecimal.valueOf(3L)), null}, {"[ {x:1, y:2}, {x:2} ].y", Arrays.asList(BigDecimal.valueOf(2L)), null}, {"[ {x:1, y:2}, {x:2, y:3} ].z", Collections.emptyList(), null}, {"[ ( 10 .. 20 ) ]", Arrays.asList(new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)BigDecimal.valueOf(10L), (Comparable)BigDecimal.valueOf(20L), Range.RangeBoundary.OPEN)), null}, {"[ ] 10 .. 20 [ ]", Arrays.asList(new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)BigDecimal.valueOf(10L), (Comparable)BigDecimal.valueOf(20L), Range.RangeBoundary.OPEN)), null}, {"[ ( duration(\"P1D\") .. duration(\"P10D\") ) ]", Arrays.asList(new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Duration.parse("P1D"), (Comparable)Duration.parse("P10D"), Range.RangeBoundary.OPEN)), null}, {"[ ( duration(\"P1D\") .. duration(\"P10D\") [ ]", Arrays.asList(new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Duration.parse("P1D"), (Comparable)Duration.parse("P10D"), Range.RangeBoundary.OPEN)), null}, {"[ ( duration(\"P1D\") .. duration(\"P10D\") ] ]", Arrays.asList(new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Duration.parse("P1D"), (Comparable)Duration.parse("P10D"), Range.RangeBoundary.CLOSED)), null}, {"[ ] duration(\"P1D\") .. duration(\"P10D\") ) ]", Arrays.asList(new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Duration.parse("P1D"), (Comparable)Duration.parse("P10D"), Range.RangeBoundary.OPEN)), null}, {"[ ] duration(\"P1D\") .. duration(\"P10D\") [ ]", Arrays.asList(new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Duration.parse("P1D"), (Comparable)Duration.parse("P10D"), Range.RangeBoundary.OPEN)), null}, {"[ ] duration(\"P1D\") .. duration(\"P10D\") ] ]", Arrays.asList(new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Duration.parse("P1D"), (Comparable)Duration.parse("P10D"), Range.RangeBoundary.CLOSED)), null}, {"[ [ duration(\"P1D\") .. duration(\"P10D\") ) ]", Arrays.asList(new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Duration.parse("P1D"), (Comparable)Duration.parse("P10D"), Range.RangeBoundary.OPEN)), null}, {"[ [ duration(\"P1D\") .. duration(\"P10D\") [ ]", Arrays.asList(new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Duration.parse("P1D"), (Comparable)Duration.parse("P10D"), Range.RangeBoundary.OPEN)), null}, {"[ [ duration(\"P1D\") .. duration(\"P10D\") ] ]", Arrays.asList(new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Duration.parse("P1D"), (Comparable)Duration.parse("P10D"), Range.RangeBoundary.CLOSED)), null}, {"[ ( duration(\"P1D\") .. duration(\"P10D\") ), ( duration(\"P2D\") .. duration(\"P10D\") )][1]", new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Duration.parse("P1D"), (Comparable)Duration.parse("P10D"), Range.RangeBoundary.OPEN), null}};
        return Arrays.asList(cases);
    }
}

