/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.MinFunction;

public class MinFunctionTest {
    private MinFunction minFunction;

    @Before
    public void setUp() {
        this.minFunction = new MinFunction();
    }

    @Test
    public void invokeNullList() {
        FunctionTestUtil.assertResultError(this.minFunction.invoke((List)null), InvalidParametersEvent.class);
    }

    @Test
    public void invokeEmptyList() {
        FunctionTestUtil.assertResultError(this.minFunction.invoke(Collections.emptyList()), InvalidParametersEvent.class);
    }

    @Test
    public void invokeListWithHeterogenousTypes() {
        FunctionTestUtil.assertResultError(this.minFunction.invoke(Arrays.asList(1, "test", BigDecimal.valueOf(10.2))), InvalidParametersEvent.class);
    }

    @Test
    public void invokeListOfIntegers() {
        FunctionTestUtil.assertResult(this.minFunction.invoke(Collections.singletonList(1)), 1);
        FunctionTestUtil.assertResult(this.minFunction.invoke(Arrays.asList(1, 2, 3)), 1);
        FunctionTestUtil.assertResult(this.minFunction.invoke(Arrays.asList(2, 1, 3)), 1);
        FunctionTestUtil.assertResult(this.minFunction.invoke(Arrays.asList(2, 3, 1)), 1);
    }

    @Test
    public void invokeListOfStrings() {
        FunctionTestUtil.assertResult(this.minFunction.invoke(Collections.singletonList("a")), "a");
        FunctionTestUtil.assertResult(this.minFunction.invoke(Arrays.asList("a", "b", "c")), "a");
        FunctionTestUtil.assertResult(this.minFunction.invoke(Arrays.asList("b", "a", "c")), "a");
        FunctionTestUtil.assertResult(this.minFunction.invoke(Arrays.asList("b", "c", "a")), "a");
    }

    @Test
    public void invokeNullArray() {
        FunctionTestUtil.assertResultError(this.minFunction.invoke((Object[])null), InvalidParametersEvent.class);
    }

    @Test
    public void invokeEmptyArray() {
        FunctionTestUtil.assertResultError(this.minFunction.invoke(new Object[0]), InvalidParametersEvent.class);
    }

    @Test
    public void invokeArrayWithHeterogenousTypes() {
        FunctionTestUtil.assertResultError(this.minFunction.invoke(new Object[]{1, "test", BigDecimal.valueOf(10.2)}), InvalidParametersEvent.class);
    }

    @Test
    public void invokeArrayOfIntegers() {
        FunctionTestUtil.assertResult(this.minFunction.invoke(new Object[]{1}), 1);
        FunctionTestUtil.assertResult(this.minFunction.invoke(new Object[]{1, 2, 3}), 1);
        FunctionTestUtil.assertResult(this.minFunction.invoke(new Object[]{2, 1, 3}), 1);
        FunctionTestUtil.assertResult(this.minFunction.invoke(new Object[]{2, 3, 1}), 1);
    }

    @Test
    public void invokeArrayOfStrings() {
        FunctionTestUtil.assertResult(this.minFunction.invoke(new Object[]{"a"}), "a");
        FunctionTestUtil.assertResult(this.minFunction.invoke(new Object[]{"a", "b", "c"}), "a");
        FunctionTestUtil.assertResult(this.minFunction.invoke(new Object[]{"b", "a", "c"}), "a");
        FunctionTestUtil.assertResult(this.minFunction.invoke(new Object[]{"b", "c", "a"}), "a");
    }
}

