/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.TimeFunction;

public class TimeFunctionTest {
    private TimeFunction timeFunction;

    @Before
    public void setUp() {
        this.timeFunction = new TimeFunction();
    }

    @Test
    public void invokeStringParamNull() {
        FunctionTestUtil.assertResultError(this.timeFunction.invoke((String)null), InvalidParametersEvent.class);
    }

    @Test
    public void invokeStringParamNotDateOrTime() {
        FunctionTestUtil.assertResultError(this.timeFunction.invoke("test"), InvalidParametersEvent.class);
    }

    @Test
    public void invokeStringParamTimeWrongFormat() {
        FunctionTestUtil.assertResultError(this.timeFunction.invoke("10-15:06"), InvalidParametersEvent.class);
    }

    @Test
    public void invokeStringParamNoOffset() {
        FunctionTestUtil.assertResult(this.timeFunction.invoke("10:15:06"), LocalTime.of(10, 15, 6));
    }

    @Test
    public void invokeStringParamWithOffset() {
        FunctionTestUtil.assertResult(this.timeFunction.invoke("10:15:06+01:00"), OffsetTime.of(10, 15, 6, 0, ZoneOffset.ofHours(1)));
        FunctionTestUtil.assertResult(this.timeFunction.invoke("10:15:06-01:00"), OffsetTime.of(10, 15, 6, 0, ZoneOffset.ofHours(-1)));
    }

    @Test
    public void parseWithZone() {
        TemporalAccessor parsedResult = (TemporalAccessor)this.timeFunction.invoke("00:01:00@Etc/UTC").getOrElse(null);
        Assert.assertEquals((Object)LocalTime.of(0, 1, 0), (Object)parsedResult.query(TemporalQueries.localTime()));
        Assert.assertEquals((Object)ZoneId.of("Etc/UTC"), (Object)parsedResult.query(TemporalQueries.zone()));
    }

    @Test
    public void parseWithZoneIANA() {
        TemporalAccessor parsedResult = (TemporalAccessor)this.timeFunction.invoke("00:01:00@Europe/Paris").getOrElse(null);
        Assert.assertEquals((Object)LocalTime.of(0, 1, 0), (Object)parsedResult.query(TemporalQueries.localTime()));
        Assert.assertEquals((Object)ZoneId.of("Europe/Paris"), (Object)parsedResult.query(TemporalQueries.zone()));
    }

    @Test
    public void invokeWrongIANAformat() {
        FunctionTestUtil.assertResultError(this.timeFunction.invoke("13:20:00+02:00@Europe/Paris"), InvalidParametersEvent.class);
    }

    @Test
    public void invokeTemporalAccessorParamNull() {
        FunctionTestUtil.assertResultError(this.timeFunction.invoke((TemporalAccessor)null), InvalidParametersEvent.class);
    }

    @Test
    public void invokeTemporalAccessorParamUnsupportedAccessor() {
        FunctionTestUtil.assertResultError(this.timeFunction.invoke((TemporalAccessor)DayOfWeek.MONDAY), InvalidParametersEvent.class);
    }

    @Test
    public void invokeTemporalAccessorParamDate() {
        FunctionTestUtil.assertResult(this.timeFunction.invoke((TemporalAccessor)LocalDate.of(2017, 6, 12)), OffsetTime.of(0, 0, 0, 0, ZoneOffset.UTC));
    }

    @Test
    public void invokeTemporalAccessorParamTime() {
        FunctionTestUtil.assertResult(this.timeFunction.invoke((TemporalAccessor)LocalTime.of(11, 43)), LocalTime.of(11, 43, 0));
    }

    @Test
    public void invokeTemporalAccessorParamDateTime() {
        FunctionTestUtil.assertResult(this.timeFunction.invoke((TemporalAccessor)LocalDateTime.of(2017, 6, 12, 11, 43)), LocalTime.of(11, 43, 0));
    }

    @Test
    public void invokeTimeUnitsParamsNull() {
        FunctionTestUtil.assertResultError(this.timeFunction.invoke(null, null, null, null), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.timeFunction.invoke(null, null, (Number)1, null), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.timeFunction.invoke(null, (Number)1, null, null), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.timeFunction.invoke(null, (Number)1, (Number)1, null), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.timeFunction.invoke((Number)1, null, null, null), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.timeFunction.invoke((Number)1, null, (Number)1, null), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.timeFunction.invoke((Number)1, (Number)1, null, null), InvalidParametersEvent.class);
    }

    @Test
    public void invokeTimeUnitsParamsUnsupportedNumber() {
        FunctionTestUtil.assertResultError(this.timeFunction.invoke((Number)Double.POSITIVE_INFINITY, (Number)1, (Number)1, null), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.timeFunction.invoke((Number)Double.NEGATIVE_INFINITY, (Number)1, (Number)1, null), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.timeFunction.invoke((Number)1, (Number)Double.POSITIVE_INFINITY, (Number)1, null), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.timeFunction.invoke((Number)1, (Number)Double.NEGATIVE_INFINITY, (Number)1, null), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.timeFunction.invoke((Number)1, (Number)1, (Number)Double.POSITIVE_INFINITY, null), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.timeFunction.invoke((Number)1, (Number)1, (Number)Double.NEGATIVE_INFINITY, null), InvalidParametersEvent.class);
    }

    @Test
    public void invokeTimeUnitsParamsOutOfBounds() {
        FunctionTestUtil.assertResultError(this.timeFunction.invoke((Number)40, (Number)1, (Number)1, null), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.timeFunction.invoke((Number)1, (Number)900, (Number)1, null), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.timeFunction.invoke((Number)1, (Number)1, (Number)900, null), InvalidParametersEvent.class);
    }

    @Test
    public void invokeTimeUnitsParamsNoOffset() {
        FunctionTestUtil.assertResult(this.timeFunction.invoke((Number)10, (Number)43, (Number)15, null), LocalTime.of(10, 43, 15));
    }

    @Test
    public void invokeTimeUnitsParamsNoOffsetWithNanoseconds() {
        FunctionTestUtil.assertResult(this.timeFunction.invoke((Number)10, (Number)43, (Number)BigDecimal.valueOf(15.154), null), LocalTime.of(10, 43, 15, 154000000));
    }

    @Test
    public void invokeTimeUnitsParamsWithOffset() {
        FunctionTestUtil.assertResult(this.timeFunction.invoke((Number)10, (Number)43, (Number)15, Duration.ofHours(1L)), OffsetTime.of(10, 43, 15, 0, ZoneOffset.ofHours(1)));
        FunctionTestUtil.assertResult(this.timeFunction.invoke((Number)10, (Number)43, (Number)15, Duration.ofHours(-1L)), OffsetTime.of(10, 43, 15, 0, ZoneOffset.ofHours(-1)));
    }

    @Test
    public void invokeTimeUnitsParamsWithOffsetWithNanoseconds() {
        FunctionTestUtil.assertResult(this.timeFunction.invoke((Number)10, (Number)43, (Number)BigDecimal.valueOf(15.154), Duration.ofHours(1L)), OffsetTime.of(10, 43, 15, 154000000, ZoneOffset.ofHours(1)));
        FunctionTestUtil.assertResult(this.timeFunction.invoke((Number)10, (Number)43, (Number)BigDecimal.valueOf(15.154), Duration.ofHours(-1L)), OffsetTime.of(10, 43, 15, 154000000, ZoneOffset.ofHours(-1)));
    }
}

