/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.StartsWithFunction;

public class StartsWithFunctionTest {
    private StartsWithFunction startsWithFunction;

    @Before
    public void setUp() {
        this.startsWithFunction = new StartsWithFunction();
    }

    @Test
    public void invokeNull() {
        FunctionTestUtil.assertResultError(this.startsWithFunction.invoke((String)null, null), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.startsWithFunction.invoke(null, "test"), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.startsWithFunction.invoke("test", null), InvalidParametersEvent.class);
    }

    @Test
    public void invokeEmptyString() {
        FunctionTestUtil.assertResult(this.startsWithFunction.invoke("", ""), true);
        FunctionTestUtil.assertResult(this.startsWithFunction.invoke("", "test"), false);
        FunctionTestUtil.assertResult(this.startsWithFunction.invoke("test", ""), true);
    }

    @Test
    public void invokeStartsWith() {
        FunctionTestUtil.assertResult(this.startsWithFunction.invoke("test", "te"), true);
        FunctionTestUtil.assertResult(this.startsWithFunction.invoke("test", "t"), true);
        FunctionTestUtil.assertResult(this.startsWithFunction.invoke("test", "test"), true);
    }

    @Test
    public void invokeNotStartsWith() {
        FunctionTestUtil.assertResult(this.startsWithFunction.invoke("test", "tte"), false);
        FunctionTestUtil.assertResult(this.startsWithFunction.invoke("test", "tt"), false);
        FunctionTestUtil.assertResult(this.startsWithFunction.invoke("test", "ttest"), false);
    }
}

